/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolUtils;

public class CrossProductTokenizationTest
extends TestCase {
    private FiniteAlphabet simple_alpha;
    private FiniteAlphabet cross_alpha;
    private SymbolList cross_atomicSymbols;
    private SymbolTokenization nameTokenization;

    public CrossProductTokenizationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.simple_alpha = DNATools.getDNA();
        this.cross_alpha = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(Collections.nCopies(2, this.simple_alpha));
        ArrayList atomics = new ArrayList();
        Iterator i = this.cross_alpha.iterator();
        while (i.hasNext()) {
            atomics.add(i.next());
        }
        this.cross_atomicSymbols = new SimpleSymbolList(this.cross_alpha, atomics);
        this.nameTokenization = this.cross_alpha.getTokenization("name");
    }

    public void testAtomicNames() throws Exception {
        String tokenization = this.nameTokenization.tokenizeSymbolList(this.cross_atomicSymbols);
        SimpleSymbolList reconstruction = new SimpleSymbolList(this.nameTokenization, tokenization);
        CrossProductTokenizationTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(this.cross_atomicSymbols, reconstruction));
    }
}

