/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.StaticMemberPlaceHolder;
import org.biojava.utils.Unchangeable;

class EmptyAlphabet
extends Unchangeable
implements FiniteAlphabet,
Serializable {
    EmptyAlphabet() {
    }

    @Override
    public String getName() {
        return "Empty Alphabet";
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    @Override
    public boolean contains(Symbol s) {
        return s == AlphabetManager.getGapSymbol();
    }

    @Override
    public void validate(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("The empty alphabet does not contain symbol " + sym.getName());
    }

    @Override
    public SymbolTokenization getTokenization(String name) throws NoSuchElementException {
        throw new NoSuchElementException("There is no parser for the empty alphabet. Attempted to retrieve " + name);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public List getAlphabets() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Symbol getSymbol(List syms) throws IllegalSymbolException {
        if (syms.size() != 0) {
            throw new IllegalSymbolException("The empty alphabet contains nothing");
        }
        return AlphabetManager.getGapSymbol();
    }

    @Override
    public Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
        Iterator i = syms.iterator();
        while (i.hasNext()) {
            this.validate((Symbol)i.next());
        }
        return AlphabetManager.getGapSymbol();
    }

    @Override
    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol();
    }

    @Override
    public Iterator iterator() {
        return SymbolList.EMPTY_LIST.iterator();
    }

    @Override
    public void addSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + sym.getName() + " in " + this.getName());
    }

    @Override
    public void removeSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + sym.getName() + " in " + this.getName());
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder(Alphabet.class.getField("EMPTY_ALPHABET"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }
}

