/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.StaticMemberPlaceHolder;

class EmptyLocation
implements Location,
Serializable {
    EmptyLocation() {
    }

    @Override
    public Location getDecorator(Class decoratorClass) {
        if (decoratorClass.isInstance(this)) {
            return this;
        }
        return null;
    }

    @Override
    public Location newInstance(Location loc) {
        return loc;
    }

    @Override
    public int getMin() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMax() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean overlaps(Location l) {
        return false;
    }

    @Override
    public boolean contains(Location l) {
        return false;
    }

    @Override
    public boolean contains(int p) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Location) {
            if (o instanceof EmptyLocation) {
                return true;
            }
            return Location.naturalOrder.areEqual(this, (Location)o);
        }
        return false;
    }

    @Override
    public Location intersection(Location l) {
        return empty;
    }

    @Override
    public Location union(Location l) {
        return l;
    }

    @Override
    public SymbolList symbols(SymbolList seq) {
        try {
            return new SimpleSymbolList(seq.getAlphabet(), new ArrayList());
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    @Override
    public Location translate(int dist) {
        return this;
    }

    @Override
    public boolean isContiguous() {
        return true;
    }

    @Override
    public Iterator blockIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder(Location.class.getField("empty"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }

    public String toString() {
        return "{}";
    }
}

