/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashSet;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.Unchangeable;

class FullDnaAlphabetIndex
extends Unchangeable
implements AlphabetIndex,
Serializable {
    static Symbol[] symbolArray = null;
    FiniteAlphabet dna = null;
    AlphabetIndex alphaIndex = null;

    public FullDnaAlphabetIndex() throws BioException {
        if (symbolArray == null) {
            this.makeSymbolArray();
        }
    }

    @Override
    public FiniteAlphabet getAlphabet() {
        return this.dna;
    }

    @Override
    public int indexForSymbol(Symbol sym) throws IllegalSymbolException {
        for (int i = 0; i < 16; ++i) {
            if (sym != symbolArray[i]) continue;
            return i;
        }
        throw new IllegalSymbolException("can't find symbol " + sym);
    }

    @Override
    public Symbol symbolForIndex(int index) {
        if (index < 0 || index > 15) {
            throw new IndexOutOfBoundsException();
        }
        return symbolArray[index];
    }

    private void makeSymbolArray() throws IllegalSymbolException {
        symbolArray = new Symbol[16];
        if (this.dna == null) {
            this.dna = DNATools.getDNA();
        }
        FullDnaAlphabetIndex.symbolArray[4] = AlphabetManager.getGapSymbol();
        FullDnaAlphabetIndex.symbolArray[0] = DNATools.a();
        FullDnaAlphabetIndex.symbolArray[1] = DNATools.c();
        FullDnaAlphabetIndex.symbolArray[2] = DNATools.g();
        FullDnaAlphabetIndex.symbolArray[3] = DNATools.t();
        HashSet<AtomicSymbol> ambiguitySet = new HashSet<AtomicSymbol>(3);
        ambiguitySet.add(DNATools.g());
        ambiguitySet.add(DNATools.t());
        FullDnaAlphabetIndex.symbolArray[5] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.c());
        ambiguitySet.add(DNATools.t());
        FullDnaAlphabetIndex.symbolArray[6] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.c());
        ambiguitySet.add(DNATools.g());
        FullDnaAlphabetIndex.symbolArray[7] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.c());
        ambiguitySet.add(DNATools.g());
        ambiguitySet.add(DNATools.t());
        FullDnaAlphabetIndex.symbolArray[8] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.a());
        ambiguitySet.add(DNATools.t());
        FullDnaAlphabetIndex.symbolArray[9] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.a());
        ambiguitySet.add(DNATools.g());
        FullDnaAlphabetIndex.symbolArray[10] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.a());
        ambiguitySet.add(DNATools.g());
        ambiguitySet.add(DNATools.t());
        FullDnaAlphabetIndex.symbolArray[11] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.a());
        ambiguitySet.add(DNATools.c());
        FullDnaAlphabetIndex.symbolArray[12] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.a());
        ambiguitySet.add(DNATools.c());
        ambiguitySet.add(DNATools.t());
        FullDnaAlphabetIndex.symbolArray[13] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.a());
        ambiguitySet.add(DNATools.c());
        ambiguitySet.add(DNATools.g());
        FullDnaAlphabetIndex.symbolArray[14] = this.dna.getAmbiguity(ambiguitySet);
        ambiguitySet.clear();
        ambiguitySet.add(DNATools.a());
        ambiguitySet.add(DNATools.c());
        ambiguitySet.add(DNATools.g());
        ambiguitySet.add(DNATools.t());
        FullDnaAlphabetIndex.symbolArray[15] = this.dna.getAmbiguity(ambiguitySet);
    }
}

