/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleGappedSymbolList;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolUtils;

public class GappedSymbolListTest
extends TestCase {
    private SymbolList symList;
    private SymbolList symList1;
    private SymbolList symList2;
    private SymbolList symList3;
    private SymbolList symList4;

    public GappedSymbolListTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        FiniteAlphabet dna = (FiniteAlphabet)AlphabetManager.alphabetForName("DNA");
        SymbolTokenization tok = dna.getTokenization("token");
        this.symList = new SimpleSymbolList(tok, "gtgtggga");
        this.symList1 = new SimpleSymbolList(tok, "gtg-tggga");
        this.symList2 = new SimpleSymbolList(tok, "gtg--tggga");
        this.symList3 = new SimpleSymbolList(tok, "gtg---tggga");
        this.symList4 = new SimpleSymbolList(tok, "gtg----tggga");
    }

    public void testIndividualInsertBlockRemove() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList));
        gsl.addGapInSource(4);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList1));
        gsl.addGapInSource(4);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList2));
        gsl.addGapInSource(4);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList3));
        gsl.addGapInSource(4);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList4));
        gsl.removeGaps(4, 4);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList));
    }

    public void testBlockedInsertIndividualRemove() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        GappedSymbolListTest.assertTrue((String)("Gapped same as ungapped:\n" + gsl.seqString() + "\n" + this.symList.seqString()), (boolean)SymbolUtils.compareSymbolLists(gsl, this.symList));
        gsl.addGapsInSource(4, 4);
        GappedSymbolListTest.assertTrue((String)("Four gaps:\n" + gsl.seqString() + "\n" + this.symList4.seqString()), (boolean)SymbolUtils.compareSymbolLists(gsl, this.symList4));
        gsl.removeGap(4);
        GappedSymbolListTest.assertTrue((String)("Three gaps:\n" + gsl.seqString() + "\n" + this.symList3.seqString()), (boolean)SymbolUtils.compareSymbolLists(gsl, this.symList3));
        gsl.removeGap(4);
        GappedSymbolListTest.assertTrue((String)("Two gaps:\n" + gsl.seqString() + "\n" + this.symList2.seqString()), (boolean)SymbolUtils.compareSymbolLists(gsl, this.symList2));
        gsl.removeGap(4);
        GappedSymbolListTest.assertTrue((String)("One gap:\n" + gsl.seqString() + "\n" + this.symList1.seqString()), (boolean)SymbolUtils.compareSymbolLists(gsl, this.symList1));
        gsl.removeGap(4);
        GappedSymbolListTest.assertTrue((String)("All gaps removed:\n" + gsl.seqString() + "\n" + this.symList.seqString()), (boolean)SymbolUtils.compareSymbolLists(gsl, this.symList));
    }

    public void testBlockedInsertBlockRemove() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList));
        gsl.addGapsInSource(4, 4);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList4));
        gsl.removeGaps(4, 4);
        GappedSymbolListTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(gsl, this.symList));
    }

    public void testBeginningGap() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        gsl.addGapInSource(1);
        GappedSymbolListTest.assertTrue((String)("Begining gap is the empty gap: " + Alphabet.EMPTY_ALPHABET.getGapSymbol() + " vs " + gsl.symbolAt(1)), (Alphabet.EMPTY_ALPHABET.getGapSymbol() == gsl.symbolAt(1) ? 1 : 0) != 0);
    }

    public void testBeginningGaps() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        gsl.addGapsInSource(1, 4);
        for (int i = 1; i <= 4; ++i) {
            GappedSymbolListTest.assertTrue((String)("Begining gap " + i + " is the empty gap: " + Alphabet.EMPTY_ALPHABET.getGapSymbol() + " vs " + gsl.symbolAt(i)), (Alphabet.EMPTY_ALPHABET.getGapSymbol() == gsl.symbolAt(i) ? 1 : 0) != 0);
        }
    }

    public void testTrailingGap() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        gsl.addGapInSource(this.symList.length() + 1);
        GappedSymbolListTest.assertTrue((String)("Trailing gap is the empty gap: " + Alphabet.EMPTY_ALPHABET.getGapSymbol() + " vs " + gsl.symbolAt(gsl.length())), (Alphabet.EMPTY_ALPHABET.getGapSymbol() == gsl.symbolAt(gsl.length()) ? 1 : 0) != 0);
    }

    public void testTrailingGaps() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        gsl.addGapsInSource(this.symList.length() + 1, 4);
        for (int i = 1; i <= 4; ++i) {
            GappedSymbolListTest.assertTrue((String)("Trailing gap " + i + " is the empty gap: " + Alphabet.EMPTY_ALPHABET.getGapSymbol() + " vs " + gsl.symbolAt(gsl.length() + 1 - i)), (Alphabet.EMPTY_ALPHABET.getGapSymbol() == gsl.symbolAt(gsl.length() + 1 - i) ? 1 : 0) != 0);
        }
    }

    public void testInternalGap() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        gsl.addGapInSource(4);
        GappedSymbolListTest.assertTrue((String)("Internal gap is the apropreate gap: " + gsl.getAlphabet().getGapSymbol() + " vs " + gsl.symbolAt(4)), (gsl.getAlphabet().getGapSymbol() == gsl.symbolAt(4) ? 1 : 0) != 0);
    }

    public void testInternalGaps() throws Exception {
        SimpleGappedSymbolList gsl = new SimpleGappedSymbolList(this.symList);
        gsl.addGapsInSource(4, 4);
        for (int i = 4; i < 8; ++i) {
            GappedSymbolListTest.assertTrue((String)("Internal gap " + i + " is the apropreate gap: " + gsl.getAlphabet().getGapSymbol() + " vs " + gsl.symbolAt(i)), (gsl.getAlphabet().getGapSymbol() == gsl.symbolAt(i) ? 1 : 0) != 0);
        }
    }

    public void testDavidBug() throws Exception {
        SymbolTokenization dnaToke1 = DNATools.getDNA().getTokenization("token");
        SimpleSymbolList symbolList = new SimpleSymbolList(dnaToke1, "ACTGGACCTAAGG");
        SimpleSequence sequence = new SimpleSequence(symbolList, "test", "test", null);
        SimpleGappedSequence gappedSequence = new SimpleGappedSequence(sequence);
        gappedSequence.addGapsInView(4, 4);
        gappedSequence.removeGap(7);
        gappedSequence.removeGaps(4, 3);
        gappedSequence.addGapsInView(7, 2);
        gappedSequence.addGapsInView(9, 3);
        gappedSequence.addGapsInView(12, 2);
        gappedSequence.addGapsInView(14, 3);
        gappedSequence.addGapsInView(17, 2);
        gappedSequence.removeGap(18);
        gappedSequence.removeGaps(11, 6);
        String seqStr = gappedSequence.seqString();
        seqStr = seqStr == null ? null : seqStr;
    }
}

