/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IndexedNoAmbPack;
import org.biojava.bio.symbol.Symbol;

public class IndexedNoAmbPackTest
extends TestCase {
    public void testSymToIndexToSym() throws IllegalAlphabetException, IllegalSymbolException {
        FiniteAlphabet alpha = ProteinTools.getAlphabet();
        AlphabetIndex index = AlphabetManager.getAlphabetIndex(alpha);
        IndexedNoAmbPack packing = new IndexedNoAmbPack(index);
        Iterator i = alpha.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            byte packed = packing.pack(sym);
            Symbol unpacked = packing.unpack(packed);
            IndexedNoAmbPackTest.assertEquals((String)"Packing and unpacking round-trips", (Object)sym, (Object)unpacked);
        }
    }

    public void testIndexToSymToIndex() throws IllegalAlphabetException, IllegalSymbolException {
        FiniteAlphabet alpha = ProteinTools.getAlphabet();
        AlphabetIndex index = AlphabetManager.getAlphabetIndex(alpha);
        IndexedNoAmbPack packing = new IndexedNoAmbPack(index);
        for (byte i = 0; i < alpha.size(); i = (byte)(i + 1)) {
            Symbol unpacked = packing.unpack(i);
            byte repacked = packing.pack(unpacked);
            IndexedNoAmbPackTest.assertEquals((String)"Unpacking and packing round-trips", (byte)i, (byte)repacked);
        }
    }
}

