/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.IntegerTokenization;
import org.biojava.bio.seq.io.SubIntegerTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;
import org.biojava.utils.StaticMemberPlaceHolder;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.cache.WeakValueHashMap;

public final class IntegerAlphabet
extends Unchangeable
implements Alphabet,
Serializable {
    public static IntegerAlphabet INSTANCE;
    private WeakValueHashMap intToSym = new WeakValueHashMap();

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder(IntegerAlphabet.class.getField("INSTANCE"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }

    public static SubIntegerAlphabet getSubAlphabet(int min, int max) throws IllegalArgumentException {
        String name = "SUBINTEGER[" + min + ".." + max + "]";
        if (AlphabetManager.registered(name)) {
            return (SubIntegerAlphabet)AlphabetManager.alphabetForName(name);
        }
        SubIntegerAlphabet a = new SubIntegerAlphabet(min, max);
        AlphabetManager.registerAlphabet(a.getName(), (Alphabet)a);
        return (SubIntegerAlphabet)AlphabetManager.alphabetForName(name);
    }

    public static SymbolList fromArray(int[] iArray) {
        return new IntegerArray(iArray);
    }

    public static IntegerAlphabet getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IntegerAlphabet();
            AlphabetManager.registerAlphabet("Alphabet of all integers.", (Alphabet)INSTANCE);
        }
        return INSTANCE;
    }

    private IntegerAlphabet() {
    }

    public synchronized IntegerSymbol getSymbol(int val) {
        Integer i = new Integer(val);
        IntegerSymbol sym = (IntegerSymbol)this.intToSym.get(i);
        if (sym == null) {
            sym = new IntegerSymbol(val);
            this.intToSym.put(i, sym);
        }
        return sym;
    }

    @Override
    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    @Override
    public List getAlphabets() {
        return new SingletonList(this);
    }

    @Override
    public Symbol getSymbol(List symList) throws IllegalSymbolException {
        throw new BioError("Unimplemneted method");
    }

    @Override
    public Symbol getAmbiguity(Set symSet) throws IllegalSymbolException {
        throw new BioError("Unimplemneted method");
    }

    @Override
    public boolean contains(Symbol s) {
        return s instanceof IntegerSymbol;
    }

    @Override
    public void validate(Symbol s) throws IllegalSymbolException {
        if (!this.contains(s)) {
            throw new IllegalSymbolException("Only symbols of type IntegerAlphabet.IntegerSymbol are valid for this alphabet.\n(" + s.getClass() + ") " + s.getName());
        }
    }

    @Override
    public String getName() {
        return "INTEGER";
    }

    @Override
    public SymbolTokenization getTokenization(String name) {
        if (name.equals("token") || name.equals("default")) {
            return new IntegerTokenization();
        }
        throw new NoSuchElementException(name + " parser not supported by IntegerAlphabet yet");
    }

    public static class SubIntegerAlphabet
    extends AbstractAlphabet {
        private int min;
        private int max;
        private String name;

        private SubIntegerAlphabet(int min, int max) throws IllegalArgumentException {
            if (max < min) {
                throw new IllegalArgumentException("min must be less than max: " + min + " : " + max);
            }
            this.min = min;
            this.max = max;
            this.name = "SUBINTEGER[" + min + ".." + max + "]";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        protected boolean containsImpl(AtomicSymbol sym) {
            if (!IntegerAlphabet.getInstance().contains(sym)) {
                return false;
            }
            IntegerSymbol is = (IntegerSymbol)sym;
            return is.intValue() >= this.min && is.intValue() <= this.max;
        }

        @Override
        public SymbolTokenization getTokenization(String name) {
            if (name.equals("token") || name.equals("default")) {
                return new SubIntegerTokenization(this);
            }
            throw new NoSuchElementException(name + " parser not supported by IntegerAlphabet yet");
        }

        public IntegerSymbol getSymbol(int val) throws IllegalSymbolException {
            if (val < this.min || val > this.max) {
                throw new IllegalSymbolException("Could not get Symbol for value " + val + " as it is not in the range " + this.min + " : " + this.max);
            }
            return IntegerAlphabet.getInstance().getSymbol(val);
        }

        @Override
        public int size() {
            return this.max - this.min + 1;
        }

        @Override
        public List getAlphabets() {
            return new SingletonList(this);
        }

        @Override
        protected AtomicSymbol getSymbolImpl(List symL) throws IllegalSymbolException {
            if (symL.size() != 1) {
                throw new IllegalSymbolException("SubIntegerAlphabet is one-dimensional: " + this.getName() + " : " + symL);
            }
            AtomicSymbol s = (AtomicSymbol)symL.get(0);
            this.validate(s);
            return s;
        }

        @Override
        protected void addSymbolImpl(AtomicSymbol sym) throws ChangeVetoException {
            throw new ChangeVetoException("Can't add symbols to immutable alphabet " + this.getName());
        }

        @Override
        public void removeSymbol(Symbol sym) throws ChangeVetoException {
            throw new ChangeVetoException("Can't remove symbols from immutable alphabet " + this.getName());
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                int indx;
                {
                    this.indx = SubIntegerAlphabet.this.min;
                }

                @Override
                public boolean hasNext() {
                    return this.indx <= SubIntegerAlphabet.this.max;
                }

                public Object next() {
                    try {
                        IntegerSymbol sym = SubIntegerAlphabet.this.getSymbol(this.indx);
                        ++this.indx;
                        return sym;
                    }
                    catch (IllegalSymbolException ise) {
                        throw new BioError("Assertion Failure: symbol " + this.indx + " produced by iterator but not found in " + SubIntegerAlphabet.this.getName(), ise);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }
    }

    private static class IntegerArray
    extends AbstractSymbolList
    implements Serializable {
        private final int[] iArray;

        @Override
        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        @Override
        public Symbol symbolAt(int i) {
            return new IntegerSymbol(this.iArray[i - 1]);
        }

        @Override
        public int length() {
            return this.iArray.length;
        }

        public IntegerArray(int[] iArray) {
            this.iArray = iArray;
        }
    }

    public static class IntegerSymbol
    extends Unchangeable
    implements AtomicSymbol,
    Serializable {
        private final int val;
        private final Alphabet matches;

        @Override
        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        @Override
        public String getName() {
            return this.val + "";
        }

        public int intValue() {
            return this.val;
        }

        @Override
        public Alphabet getMatches() {
            return this.matches;
        }

        @Override
        public List getSymbols() {
            return new SingletonList(this);
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        protected IntegerSymbol(int val) {
            this.val = val;
            this.matches = new SingletonAlphabet(this);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.intValue();
            return result;
        }

        public boolean equals(Object o) {
            IntegerSymbol i;
            if (o == this) {
                return true;
            }
            return o instanceof IntegerSymbol && (i = (IntegerSymbol)o).intValue() == this.intValue();
        }
    }
}

