/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import junit.framework.TestCase;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;

public class IntegerAlphabetTest
extends TestCase {
    public IntegerAlphabetTest(String name) {
        super(name);
    }

    public void testCanonicalAlphabet() {
        IntegerAlphabetTest.assertEquals((Object)AlphabetManager.alphabetForName("INTEGER"), (Object)IntegerAlphabet.getInstance());
        IntegerAlphabetTest.assertEquals((Object)IntegerAlphabet.getInstance(), (Object)IntegerAlphabet.getInstance());
    }

    public void testCanonicalSymbols() {
        int i;
        Symbol[] syms = new Symbol[10];
        for (i = 0; i < syms.length; ++i) {
            syms[i] = IntegerAlphabet.getInstance().getSymbol(i);
        }
        for (i = 0; i < syms.length; ++i) {
            IntegerAlphabetTest.assertEquals((Object)syms[i], (Object)IntegerAlphabet.getInstance().getSymbol(i));
        }
    }

    public void testCanonicalSubAlphabet() {
        int min = 200;
        int max = 300;
        IntegerAlphabet.SubIntegerAlphabet a1 = IntegerAlphabet.getSubAlphabet(min, max);
        IntegerAlphabet.SubIntegerAlphabet a2 = IntegerAlphabet.getSubAlphabet(min, max);
        IntegerAlphabetTest.assertEquals((Object)a1, (Object)a2);
    }

    public void testSubAlphabetSymbolsCanonical() throws IllegalSymbolException {
        int min = 400;
        int max = 500;
        IntegerAlphabet alpha = IntegerAlphabet.getInstance();
        IntegerAlphabet.SubIntegerAlphabet a1 = IntegerAlphabet.getSubAlphabet(min, max);
        for (int i = min; i <= max; ++i) {
            IntegerAlphabetTest.assertEquals((Object)a1.getSymbol(i), (Object)a1.getSymbol(i));
            IntegerAlphabetTest.assertEquals((Object)a1.getSymbol(i), (Object)alpha.getSymbol(i));
        }
    }
}

