/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.LinearAlphabetIndex;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;

public class LinearAlphabetIndexTest
extends TestCase {
    FiniteAlphabet DNA = DNATools.getDNA();

    public LinearAlphabetIndexTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LinearAlphabetIndexTest.class);
        return suite;
    }

    public void testGetAlphabet() {
        System.out.println("getAlphabet");
        LinearAlphabetIndex instance = new LinearAlphabetIndex(this.DNA);
        FiniteAlphabet expResult = this.DNA;
        FiniteAlphabet result = instance.getAlphabet();
        LinearAlphabetIndexTest.assertEquals((Object)expResult, (Object)result);
    }

    public void testSymbolForIndex() {
        System.out.println("symbolForIndex");
        LinearAlphabetIndex instance = new LinearAlphabetIndex(this.DNA);
        for (int i = 0; i < this.DNA.size(); ++i) {
            Symbol result = instance.symbolForIndex(i);
            LinearAlphabetIndexTest.assertNotNull((Object)result);
            LinearAlphabetIndexTest.assertTrue((boolean)this.DNA.contains(result));
        }
    }

    public void testIndexForSymbol() throws Exception {
        System.out.println("indexForSymbol");
        Iterator i = this.DNA.iterator();
        while (i.hasNext()) {
            LinearAlphabetIndex instance = new LinearAlphabetIndex(this.DNA);
            Symbol s = (Symbol)i.next();
            int result = instance.indexForSymbol(s);
            LinearAlphabetIndexTest.assertTrue((result >= 0 ? 1 : 0) != 0);
        }
    }

    public void testBugFix2330() throws Exception {
        SimpleAlphabet alpha = new SimpleAlphabet();
        LinearAlphabetIndex index = new LinearAlphabetIndex(alpha);
        AtomicSymbol s0 = AlphabetManager.createSymbol("s0");
        alpha.addSymbol(s0);
        LinearAlphabetIndexTest.assertNotNull((Object)index.symbolForIndex(0));
        LinearAlphabetIndexTest.assertTrue((index.symbolForIndex(0) == s0 ? 1 : 0) != 0);
        LinearAlphabetIndexTest.assertTrue((index.indexForSymbol(s0) == 0 ? 1 : 0) != 0);
        alpha.removeSymbol(s0);
        try {
            index.symbolForIndex(0);
            LinearAlphabetIndexTest.fail((String)"Expected exception, there should be no Symbol at index 0");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

