/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.MergeLocation;
import org.biojava.bio.symbol.RangeLocation;

public class MergeLocationTest
extends TestCase {
    Location a;
    Location b;
    Location c;
    Location d;
    Location e;
    Location f;
    Location g;
    MergeLocation ml;
    List la;
    List lb;
    List nestl;
    Location abc;
    Location abcd;
    MergeLocation fg;
    Location nested;

    public MergeLocationTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(MergeLocationTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.a = new RangeLocation(1, 10);
        this.b = new RangeLocation(30, 40);
        this.c = new RangeLocation(35, 65);
        this.d = new RangeLocation(80, 90);
        this.e = new RangeLocation(60, 70);
        this.f = new RangeLocation(60, 64);
        this.g = new RangeLocation(65, 70);
        this.la = new ArrayList();
        this.lb = new ArrayList();
        this.nestl = new ArrayList();
        this.la.add(this.a);
        this.la.add(this.b);
        this.la.add(this.c);
        this.lb.add(this.a);
        this.lb.add(this.b);
        this.lb.add(this.c);
        this.lb.add(this.d);
        this.nestl.add(this.a);
        this.nestl.add(this.d);
        this.nestl.add(this.e);
        this.ml = MergeLocation.mergeLocations(this.b, this.c);
        this.nestl.add(this.ml);
        this.abc = LocationTools.union(this.la);
        this.abcd = LocationTools.union(this.lb);
        this.fg = MergeLocation.mergeLocations(this.f, this.g);
        this.nested = LocationTools.union(this.nestl);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInstantiation() throws Exception {
        MergeLocationTest.assertNotNull((Object)this.ml);
        MergeLocationTest.assertNotNull((Object)this.abc);
        MergeLocationTest.assertNotNull((Object)this.abcd);
        MergeLocationTest.assertNotNull((Object)this.nested);
    }

    public void testBlocks() {
        MergeLocationTest.assertNotNull((Object)this.ml.getComponentList(false));
        MergeLocationTest.assertTrue((this.fg.getComponentList(false).size() == 2 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((this.ml.getComponentList(false).size() == 2 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((this.ml.getComponentList(true).size() == 2 ? 1 : 0) != 0);
    }

    public void testTouchingMerge() {
        MergeLocationTest.assertTrue((this.fg.getComponentList(true).size() == 2 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((boolean)this.fg.isContiguous());
    }

    public void testCompoundABC() {
        int blocks = 0;
        MergeLocation loc = null;
        Iterator i = this.abc.blockIterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (item instanceof MergeLocation) {
                loc = (MergeLocation)item;
            }
            ++blocks;
        }
        MergeLocationTest.assertTrue((blocks == 2 ? 1 : 0) != 0);
        MergeLocationTest.assertNotNull(loc);
        MergeLocationTest.assertTrue((this.abc.getMax() == 65 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((this.abc.getMin() == 1 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((loc.getComponentList(false).size() == 2 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((loc.getComponentList(true).size() == 2 ? 1 : 0) != 0);
    }

    public void testCompoundABCD() {
        int blocks = 0;
        MergeLocation loc = null;
        Iterator i = this.abcd.blockIterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (item instanceof MergeLocation) {
                loc = (MergeLocation)item;
            }
            ++blocks;
        }
        MergeLocationTest.assertTrue((blocks == 3 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((this.abcd.getMin() == 1 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((this.abcd.getMax() == 90 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((loc.getComponentList(true).size() == 2 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((loc.getComponentList(false).size() == 2 ? 1 : 0) != 0);
    }

    public void testNested() {
        int blocks = 0;
        MergeLocation loc = null;
        Iterator i = this.nested.blockIterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (item instanceof MergeLocation) {
                loc = (MergeLocation)item;
            }
            ++blocks;
        }
        MergeLocationTest.assertTrue((blocks == 3 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((this.nested.getMax() == 90 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((this.nested.getMin() == 1 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((loc.getComponentList(false).size() == 2 ? 1 : 0) != 0);
        MergeLocationTest.assertTrue((loc.getComponentList(true).size() == 3 ? 1 : 0) != 0);
    }
}

