/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.MotifTools;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AssertionFailure;

public class MotifToolsTest
extends TestCase {
    protected String n;

    protected void setUp() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            SymbolTokenization sTok = DNATools.getDNA().getTokenization("token");
            FiniteAlphabet na = (FiniteAlphabet)DNATools.n().getMatches();
            Set rawSyms = AlphabetManager.getAllSymbols(na);
            ArrayList<Symbol> gapSyms = new ArrayList<Symbol>();
            for (Symbol rawSym : rawSyms) {
                if (((FiniteAlphabet)rawSym.getMatches()).size() != 0) continue;
                gapSyms.add(rawSym);
            }
            rawSyms.removeAll(gapSyms);
            Symbol[] nSyms = rawSyms.toArray(new Symbol[0]);
            char[] nChars = new char[nSyms.length];
            for (int i = 0; i < nSyms.length; ++i) {
                nChars[i] = sTok.tokenizeSymbol(nSyms[i]).charAt(0);
            }
            Arrays.sort(nChars);
            sb.append(nChars);
            sb.append("]");
            this.n = sb.toString();
        }
        catch (Exception e) {
            throw new AssertionFailure("Couldn't initialize motif tools test", e);
        }
    }

    public MotifToolsTest(String name) {
        super(name);
    }

    public void testPlain() {
        this.doTest("atcg", "atcg");
    }

    public void testTwoStart() {
        this.doTest("aatcg", "a{2}tcg");
    }

    public void testThreeStart() {
        this.doTest("aaatcg", "a{3}tcg");
    }

    public void testTwoInternal() {
        this.doTest("attcg", "at{2}cg");
    }

    public void testThreeInternal() {
        this.doTest("atttcg", "at{3}cg");
    }

    public void testTwoEnd() {
        this.doTest("atcgg", "atcg{2}");
    }

    public void testThreeEnd() {
        this.doTest("atcggg", "atcg{3}");
    }

    public void testTwoOnly() {
        this.doTest("aa", "a{2}");
    }

    public void testThreeOnly() {
        this.doTest("aaa", "a{3}");
    }

    public void testAmbStart() {
        this.doTest("ngct", this.n + "gct");
    }

    public void testAmbMiddle() {
        this.doTest("anct", "a" + this.n + "ct");
    }

    public void testAmbEnd() {
        this.doTest("agcn", "agc" + this.n);
    }

    public void testTwoAmbOnly() {
        this.doTest("nn", this.n + "{2}");
    }

    void doTest(String pattern, String target) {
        try {
            MotifToolsTest.assertEquals((String)target, (String)MotifTools.createRegex(DNATools.createDNA(pattern)));
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailure(ise);
        }
    }
}

