/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolUtils;

public class NameTokenizationTest
extends TestCase {
    private FiniteAlphabet simple_alpha;
    private SymbolList simple_atomicSymbols;
    private SymbolList simple_allSymbols;
    private SymbolTokenization nameTokenization;

    public NameTokenizationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.simple_alpha = DNATools.getDNA();
        ArrayList atomics = new ArrayList();
        Iterator i = this.simple_alpha.iterator();
        while (i.hasNext()) {
            atomics.add(i.next());
        }
        this.simple_atomicSymbols = new SimpleSymbolList(this.simple_alpha, atomics);
        ArrayList all = new ArrayList(AlphabetManager.getAllSymbols(this.simple_alpha));
        this.simple_allSymbols = new SimpleSymbolList(this.simple_alpha, all);
        this.nameTokenization = this.simple_alpha.getTokenization("name");
    }

    public void testAtomicNames() throws Exception {
        String tokenization = this.nameTokenization.tokenizeSymbolList(this.simple_atomicSymbols);
        SimpleSymbolList reconstruction = new SimpleSymbolList(this.nameTokenization, tokenization);
        NameTokenizationTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(this.simple_atomicSymbols, reconstruction));
    }

    public void testAmbiguousNames() throws Exception {
        String tokenization = this.nameTokenization.tokenizeSymbolList(this.simple_allSymbols);
        SimpleSymbolList reconstruction = new SimpleSymbolList(this.nameTokenization, tokenization);
        NameTokenizationTest.assertTrue((boolean)SymbolUtils.compareSymbolLists(this.simple_allSymbols, reconstruction));
    }
}

