/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.PointLocation;

public class PointLocationTest
extends TestCase {
    protected Location r1;
    protected Location r2;
    protected Location r3;
    protected Location r4;

    public PointLocationTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(PointLocationTest.class);
    }

    protected void setUp() throws Exception {
        this.r1 = new PointLocation(1);
        this.r2 = new PointLocation(10);
        this.r3 = new PointLocation(11);
        this.r4 = LocationTools.makeLocation(10, 11);
    }

    public void testEquals() {
        PointLocationTest.assertEquals((Object)this.r1, (Object)this.r1);
        PointLocationTest.assertEquals((Object)this.r1, (Object)new PointLocation(1));
    }

    public void testAreEqual() {
        PointLocationTest.assertTrue((boolean)LocationTools.areEqual(this.r1, this.r1));
        PointLocationTest.assertTrue((boolean)LocationTools.areEqual(this.r1, new PointLocation(1)));
    }

    public void testOverlaps() {
        PointLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r1, this.r1));
        PointLocationTest.assertTrue((!LocationTools.overlaps(this.r1, this.r2) ? 1 : 0) != 0);
    }

    public void testContains() {
        PointLocationTest.assertTrue((boolean)LocationTools.contains(this.r1, new PointLocation(1)));
        PointLocationTest.assertTrue((!LocationTools.contains(this.r1, this.r2) ? 1 : 0) != 0);
        PointLocationTest.assertTrue((boolean)this.r1.contains(1));
        PointLocationTest.assertTrue((!this.r1.contains(2) ? 1 : 0) != 0);
    }

    public void testIntersection() {
        PointLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, this.r1), (Object)new PointLocation(1));
        PointLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, this.r2), (Object)Location.empty);
    }

    public void testUnion() {
        PointLocationTest.assertEquals((Object)this.r1, (Object)LocationTools.union(this.r1, this.r1));
        PointLocationTest.assertEquals((Object)LocationTools.union(this.r1, this.r2), (Object)LocationTools.union(this.r2, this.r1));
        PointLocationTest.assertEquals((Object)this.r4, (Object)LocationTools.union(this.r2, this.r3));
        PointLocationTest.assertTrue((boolean)LocationTools.union(this.r2, this.r3).isContiguous());
    }

    public void testIsContiguous() {
        PointLocationTest.assertTrue((boolean)this.r1.isContiguous());
    }
}

