/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;

public class RangeLocationTest
extends TestCase {
    protected Location r1;
    protected Location r2;
    protected Location r3;
    protected Location r4;
    protected Location r5;
    protected Location r6;

    public RangeLocationTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(RangeLocationTest.class);
    }

    protected void setUp() throws Exception {
        this.r1 = new RangeLocation(1, 100);
        this.r2 = new RangeLocation(90, 190);
        this.r3 = new RangeLocation(200, 300);
        this.r4 = new RangeLocation(210, 290);
        this.r5 = new RangeLocation(200, 209);
        this.r6 = new RangeLocation(210, 300);
    }

    public void testEquals() {
        RangeLocationTest.assertEquals((Object)this.r1, (Object)this.r1);
        RangeLocationTest.assertEquals((Object)this.r1, (Object)new RangeLocation(1, 100));
    }

    public void testAreEqual() {
        RangeLocationTest.assertTrue((boolean)LocationTools.areEqual(this.r1, this.r1));
        RangeLocationTest.assertTrue((boolean)LocationTools.areEqual(this.r1, new RangeLocation(1, 100)));
    }

    public void testOverlaps() {
        RangeLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r1, this.r1));
        RangeLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r2, this.r2));
        RangeLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r1, this.r2));
        RangeLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r2, this.r1));
        RangeLocationTest.assertTrue((!LocationTools.overlaps(this.r1, this.r3) ? 1 : 0) != 0);
    }

    public void testContains() {
        RangeLocationTest.assertTrue((boolean)LocationTools.contains(this.r3, this.r4));
        RangeLocationTest.assertTrue((!LocationTools.contains(this.r4, this.r3) ? 1 : 0) != 0);
        RangeLocationTest.assertTrue((boolean)this.r1.contains(1));
        RangeLocationTest.assertTrue((boolean)this.r1.contains(100));
        RangeLocationTest.assertTrue((!this.r1.contains(101) ? 1 : 0) != 0);
    }

    public void testIntersection() {
        RangeLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, this.r2), (Object)LocationTools.intersection(this.r2, this.r1));
        RangeLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, this.r3), (Object)Location.empty);
        RangeLocationTest.assertEquals((Object)LocationTools.intersection(this.r3, this.r1), (Object)Location.empty);
    }

    public void testUnion() {
        RangeLocationTest.assertEquals((Object)this.r1, (Object)LocationTools.union(this.r1, this.r1));
        RangeLocationTest.assertEquals((Object)LocationTools.union(this.r1, this.r2), (Object)LocationTools.union(this.r2, this.r1));
        RangeLocationTest.assertEquals((Object)this.r3, (Object)LocationTools.union(this.r5, this.r6));
    }

    public void testIsContiguous() {
        RangeLocationTest.assertTrue((boolean)this.r1.isContiguous());
    }
}

