/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.symbol.CodonPref;
import org.biojava.bio.symbol.CodonPrefTools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ManyToOneTranslationTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.WobbleDistribution;

public class SimpleCodonPrefTest
extends TestCase {
    CodonPref testPref;
    FiniteAlphabet aaAlfa = ProteinTools.getTAlphabet();

    public SimpleCodonPrefTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.testPref = CodonPrefTools.getCodonPreference(CodonPrefTools.JUNIT);
        SimpleCodonPrefTest.assertNotNull((Object)this.testPref);
    }

    public void testGetGeneticCode() {
        ManyToOneTranslationTable prefGCode = this.testPref.getGeneticCode();
        ManyToOneTranslationTable correctGCode = RNATools.getGeneticCode("UNIVERSAL");
        SimpleCodonPrefTest.assertSame((Object)prefGCode, (Object)correctGCode);
    }

    public void testGetFrequency() {
        try {
            Distribution codonUse = this.testPref.getFrequency();
            SimpleCodonPrefTest.assertNotNull((Object)codonUse);
            FiniteAlphabet codons = RNATools.getCodonAlphabet();
            double sum = 0.0;
            Iterator codonI = codons.iterator();
            while (codonI.hasNext()) {
                sum += codonUse.getWeight((Symbol)codonI.next());
            }
            SimpleCodonPrefTest.assertTrue((Math.abs(sum - 1.0) < 1.0E-5 ? 1 : 0) != 0);
            SymbolList agc = RNATools.createRNA("agc");
            Symbol testCodon = codons.getSymbol(agc.toList());
            SimpleCodonPrefTest.assertTrue((Math.abs(codonUse.getWeight(testCodon) - 0.0234375) < 1.0E-4 ? 1 : 0) != 0);
        }
        catch (IllegalSymbolException ise) {
            SimpleCodonPrefTest.fail((String)"IllegalSymbolException occurred on codon frequency lookup");
        }
    }

    public void testGetFrequencyForSynonyms() {
        try {
            ManyToOneTranslationTable gCode = this.testPref.getGeneticCode();
            Iterator residueI = ProteinTools.getTAlphabet().iterator();
            while (residueI.hasNext()) {
                Symbol residue = (Symbol)residueI.next();
                if (residue.getName().equals("SEC") || residue.getName().equals("PYL")) continue;
                Distribution synonymUse = this.testPref.getFrequencyForSynonyms(residue);
                SimpleCodonPrefTest.assertNotNull((Object)synonymUse);
                Set synonyms = gCode.untranslate(residue);
                double sum = 0.0;
                for (Symbol synonym : synonyms) {
                    sum += synonymUse.getWeight(synonym);
                }
                SimpleCodonPrefTest.assertTrue((Math.abs(sum - 1.0) < 1.0E-4 ? 1 : 0) != 0);
            }
            SymbolList serine = ProteinTools.createProtein("S");
            SimpleCodonPrefTest.assertNotNull((Object)serine);
            Distribution serineDist = this.testPref.getFrequencyForSynonyms(serine.symbolAt(1));
            SymbolList agc = RNATools.createRNA("agc");
            Symbol testCodon = RNATools.getCodonAlphabet().getSymbol(agc.toList());
            SimpleCodonPrefTest.assertTrue((Math.abs(serineDist.getWeight(testCodon) - 0.25) < 1.0E-4 ? 1 : 0) != 0);
        }
        catch (IllegalSymbolException ise) {
            SimpleCodonPrefTest.fail((String)"IllegalSymbolException occurred on codon frequency lookup");
        }
    }

    public void testGetWobbleDistributionForSynonyms() {
        try {
            SymbolList serine = ProteinTools.createProtein("S");
            SimpleCodonPrefTest.assertNotNull((Object)serine);
            WobbleDistribution wobbleDist = this.testPref.getWobbleDistributionForSynonyms(serine.symbolAt(1));
            SimpleCodonPrefTest.assertNotNull((Object)wobbleDist);
        }
        catch (IllegalSymbolException ise) {
            SimpleCodonPrefTest.fail((String)"IllegalSymbolException occurred on wobble frequency lookup");
        }
    }
}

