/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SymbolList;

public class SimpleSymbolListTest
extends TestCase {
    protected SymbolList sl1;
    protected SymbolList sl2;

    public SimpleSymbolListTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.sl1 = DNATools.createDNA("gataca");
        this.sl2 = DNATools.createDNA("atgga");
    }

    public void testCopyConstructor() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, this.sl1));
    }

    public void testEquals() throws Exception {
        SymbolList sl = DNATools.createDNA("gataca");
        SimpleSymbolListTest.assertTrue((boolean)sl.equals(this.sl1));
        SimpleSymbolListTest.assertTrue((boolean)this.sl1.equals(sl));
        SimpleSymbolListTest.assertTrue((!sl.equals(this.sl2) ? 1 : 0) != 0);
    }

    public void testAddSymbol() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        tsl.addSymbol(DNATools.a());
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, DNATools.createDNA("gatacaa")));
    }

    public void testInsertAtStart() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        tsl.edit(new Edit(1, 0, this.sl2));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, DNATools.createDNA("atggagataca")));
    }

    public void testInsertInMiddle() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        tsl.edit(new Edit(4, 0, this.sl2));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, DNATools.createDNA("gatatggaaca")));
    }

    public void testInsertAtEnd() throws Exception {
        SimpleSymbolList ts1 = new SimpleSymbolList(this.sl1);
        ts1.edit(new Edit(7, 0, this.sl2));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(ts1, DNATools.createDNA("gatacaatgga")));
        ts1.edit(new Edit(ts1.length() + 1, 0, this.sl2));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(ts1, DNATools.createDNA("gatacaatggaatgga")));
    }

    public void testDeletion() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        tsl.edit(new Edit(4, 2, SymbolList.EMPTY_LIST));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, DNATools.createDNA("gata")));
    }

    public void testReplacement() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        tsl.edit(new Edit(4, 2, this.sl2));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, DNATools.createDNA("gatatggaa")));
    }

    public void testEditSuperlist() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        SymbolList sub_tsl = tsl.subList(2, 6);
        tsl.edit(new Edit(4, 2, this.sl2));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, DNATools.createDNA("gatatggaa")));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(sub_tsl, DNATools.createDNA("ataca")));
    }

    public void testEditSublist() throws Exception {
        SimpleSymbolList tsl = new SimpleSymbolList(this.sl1);
        SymbolList sub_tsl = tsl.subList(2, 6);
        sub_tsl.edit(new Edit(3, 2, this.sl2));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(sub_tsl, DNATools.createDNA("atatggaa")));
        SimpleSymbolListTest.assertTrue((boolean)this.compareSymbolList(tsl, DNATools.createDNA("gataca")));
    }

    private boolean compareSymbolList(SymbolList sl1, SymbolList sl2) {
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator si1 = sl1.iterator();
        Iterator si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }
}

