/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.CodonPref;
import org.biojava.bio.symbol.CodonPrefTools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.WobbleDistribution;

public class SimpleWobbleDistributionTest
extends TestCase {
    CodonPref testPref;
    FiniteAlphabet aaAlfa = ProteinTools.getTAlphabet();
    WobbleDistribution wobbleDist;
    Symbol serine;

    public SimpleWobbleDistributionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.testPref = CodonPrefTools.getCodonPreference(CodonPrefTools.JUNIT);
        SimpleWobbleDistributionTest.assertNotNull((Object)this.testPref);
        SymbolList serineL = ProteinTools.createProtein("S");
        SimpleWobbleDistributionTest.assertNotNull((Object)serineL);
        this.serine = serineL.symbolAt(1);
        this.wobbleDist = this.testPref.getWobbleDistributionForSynonyms(this.serine);
        SimpleWobbleDistributionTest.assertNotNull((Object)this.wobbleDist);
    }

    public void testWobbleDistribution() {
        try {
            SimpleWobbleDistributionTest.assertEquals((String)this.wobbleDist.getResidue().getName(), (String)"SER");
            Distribution nonWobbleDist = this.wobbleDist.getFrequencyOfNonWobbleBases();
            SimpleWobbleDistributionTest.assertNotNull((Object)nonWobbleDist);
            Set nonWobbleBases = this.wobbleDist.getNonWobbleBases();
            SimpleWobbleDistributionTest.assertNotNull((Object)nonWobbleBases);
            double sum = 0.0;
            for (AtomicSymbol dinucl : nonWobbleBases) {
                sum += nonWobbleDist.getWeight(dinucl);
            }
            SimpleWobbleDistributionTest.assertTrue((Math.abs(sum - 1.0) < 1.0E-4 ? 1 : 0) != 0);
            Symbol testNonWobble = CodonPrefTools.getDinucleotideAlphabet().getSymbol(RNATools.createRNA("ag").toList());
            SimpleWobbleDistributionTest.assertTrue((Math.abs(nonWobbleDist.getWeight(testNonWobble) - 0.333333) < 1.0E-4 ? 1 : 0) != 0);
            Distribution wobbleD = this.wobbleDist.getWobbleFrequency(testNonWobble);
            SimpleWobbleDistributionTest.assertTrue((Math.abs(wobbleD.getWeight(RNATools.c()) - 0.75) < 1.0E-4 ? 1 : 0) != 0);
        }
        catch (IllegalSymbolException ise) {
            ise.printStackTrace();
            SimpleWobbleDistributionTest.fail((String)"unexpected IllegalSymbolException");
        }
    }
}

