/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.SingletonList;

public class SingletonAlphabet
extends AbstractAlphabet
implements FiniteAlphabet,
Serializable {
    private final AtomicSymbol sym;
    private List alphabets;

    public SingletonAlphabet(AtomicSymbol sym) {
        this.sym = sym;
    }

    @Override
    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    @Override
    protected boolean containsImpl(AtomicSymbol s) {
        return s == this.sym;
    }

    @Override
    public String getName() {
        return this.sym.getName() + "-alphabet";
    }

    @Override
    public SymbolTokenization getTokenization(String name) throws NoSuchElementException {
        throw new NoSuchElementException("No parsers associated with " + this.getName() + ": " + name);
    }

    @Override
    public Iterator iterator() {
        return Collections.singleton(this.sym).iterator();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    @Override
    public void addSymbolImpl(AtomicSymbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + sym.getName() + " in " + this.getName());
    }

    @Override
    public void removeSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + sym.getName() + " in " + this.getName());
    }

    @Override
    protected AtomicSymbol getSymbolImpl(List symList) throws IllegalSymbolException {
        return (AtomicSymbol)symList.get(0);
    }
}

