/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.cache.WeakValueHashMap;

class SparseCrossProductAlphabet
extends AbstractAlphabet
implements Serializable {
    private final int size;
    private final List alphas;
    private final Map knownSymbols;

    SparseCrossProductAlphabet(List alphas) {
        this.alphas = alphas;
        this.knownSymbols = new WeakValueHashMap();
        int size = 1;
        for (FiniteAlphabet a : alphas) {
            size *= a.size();
        }
        this.size = size;
    }

    @Override
    protected ChangeSupport generateChangeSupport() {
        for (Alphabet a : this.alphas) {
            if (a.isUnchanging(Alphabet.SYMBOLS)) continue;
            return new ChangeSupport();
        }
        return new ChangeSupport(Collections.singleton(Alphabet.SYMBOLS));
    }

    @Override
    public String getName() {
        StringBuffer name = new StringBuffer("(");
        for (int i = 0; i < this.alphas.size(); ++i) {
            Alphabet a = (Alphabet)this.alphas.get(i);
            name.append(a.getName());
            if (i >= this.alphas.size() - 1) continue;
            name.append(" x ");
        }
        name.append(")");
        return name.substring(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected boolean containsImpl(AtomicSymbol s) {
        return this.knownSymbols.values().contains(s);
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    @Override
    public List getAlphabets() {
        return this.alphas;
    }

    @Override
    public Iterator iterator() {
        return new SparseIterator(this);
    }

    @Override
    protected AtomicSymbol getSymbolImpl(List sList) throws IllegalSymbolException {
        AtomicSymbol s = (AtomicSymbol)this.knownSymbols.get(sList);
        if (s == null) {
            Iterator si = sList.iterator();
            Iterator ai = this.getAlphabets().iterator();
            while (ai.hasNext()) {
                ((Alphabet)ai.next()).validate((Symbol)si.next());
            }
            ArrayList l = new ArrayList(sList);
            s = (AtomicSymbol)AlphabetManager.createSymbol(Annotation.EMPTY_ANNOTATION, l, (Alphabet)this);
            this.knownSymbols.put(s.getSymbols(), s);
        }
        return s;
    }

    @Override
    public void addSymbolImpl(AtomicSymbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + sym.getName() + " in " + this.getName());
    }

    @Override
    public void removeSymbol(Symbol sym) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + sym.getName() + " in " + this.getName());
    }

    private static class SparseIterator
    implements Iterator {
        private Alphabet parent;
        private FiniteAlphabet[] alphas;
        private Iterator[] symI;
        private AtomicSymbol[] as;
        private boolean hasNext;
        private List symList;

        public SparseIterator(FiniteAlphabet parent) {
            this.parent = parent;
            this.alphas = parent.getAlphabets().toArray(new FiniteAlphabet[0]);
            this.symI = new Iterator[this.alphas.length];
            this.as = new AtomicSymbol[this.alphas.length];
            this.hasNext = true;
            for (int i = 0; i < this.alphas.length; ++i) {
                this.symI[i] = this.alphas[i].iterator();
                if (!this.symI[i].hasNext()) {
                    this.hasNext = false;
                    return;
                }
                this.as[i] = (AtomicSymbol)this.symI[i].next();
            }
            this.symList = Arrays.asList(this.as);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            try {
                Symbol sym = this.parent.getSymbol(this.symList);
                for (int i = 0; i <= this.alphas.length; ++i) {
                    if (i == this.alphas.length) {
                        this.hasNext = false;
                        continue;
                    }
                    if (!this.symI[i].hasNext()) {
                        this.symI[i] = this.alphas[i].iterator();
                        this.as[i] = (AtomicSymbol)this.symI[i].next();
                        continue;
                    }
                    this.as[i] = (AtomicSymbol)this.symI[i].next();
                    break;
                }
                return sym;
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Assertion Failure: I should contain this symbol", ise);
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

