/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.ChunkedSymbolListFactory;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.PackedSymbolList;
import org.biojava.bio.symbol.PackedSymbolListFactory;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.PackingFactory;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class SymbolListTest
extends TestCase {
    int[] testLengths = new int[]{100, 16384, 32000, 100000};
    int noRepeats = 8;

    public SymbolListTest(String string) {
        super(string);
    }

    protected Symbol[] createRandomSymbolArray(FiniteAlphabet alpha, int length) throws Exception {
        int alfaSize = alpha.size();
        AlphabetIndex indx = AlphabetManager.getAlphabetIndex(alpha);
        Random rand = new Random();
        Symbol[] array = new Symbol[length];
        for (int i = 0; i < length; ++i) {
            array[i] = indx.symbolForIndex(rand.nextInt(alfaSize));
        }
        return array;
    }

    protected boolean compareSymbolLists(SymbolList list, Symbol[] array) {
        int length = list.length();
        if (length > array.length) {
            return false;
        }
        for (int i = 1; i <= length; ++i) {
            if (list.symbolAt(i) == array[i - 1]) continue;
            return false;
        }
        return true;
    }

    protected boolean runSymbolListTest(FiniteAlphabet arrayAlpha, FiniteAlphabet symListAlpha, int length, SymListFactory factory) throws Exception {
        Symbol[] array = this.createRandomSymbolArray(arrayAlpha, length);
        SymbolListTest.assertNotNull((Object)array);
        SymbolList symList = factory.createSymbolList(array, symListAlpha, length);
        SymbolListTest.assertNotNull((Object)symList);
        return this.compareSymbolLists(symList, array);
    }

    private boolean runRepeatedSymbolListTests(FiniteAlphabet arrayAlpha, FiniteAlphabet symListAlpha, SymListFactory factory) throws Exception {
        for (int i = 0; i < this.testLengths.length; ++i) {
            int length = this.testLengths[i];
            for (int j = 0; j < this.noRepeats; ++j) {
                SymbolListTest.assertTrue((boolean)this.runSymbolListTest(arrayAlpha, symListAlpha, length, factory));
            }
        }
        return true;
    }

    private FiniteAlphabet generateAmbiguousDNA() {
        FiniteAlphabet dna = DNATools.getDNA();
        SimpleAlphabet ambiguous = new SimpleAlphabet();
        try {
            ambiguous.addSymbol(DNATools.a());
            ambiguous.addSymbol(DNATools.c());
            ambiguous.addSymbol(DNATools.g());
            ambiguous.addSymbol(DNATools.t());
            HashSet<Symbol> chars = new HashSet<Symbol>();
            chars.add(DNATools.a());
            chars.add(DNATools.c());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.g());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.c());
            chars.add(DNATools.g());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.c());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.g());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.c());
            chars.add(DNATools.g());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.c());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.g());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.c());
            chars.add(DNATools.g());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars.add(DNATools.n());
            return ambiguous;
        }
        catch (IllegalSymbolException ise) {
            return null;
        }
        catch (ChangeVetoException cve) {
            return null;
        }
    }

    public void testPackedSymbolListWithAmbiguitySymbols() throws Exception {
        FiniteAlphabet symListAlpha = DNATools.getDNA();
        FiniteAlphabet arrayAlpha = this.generateAmbiguousDNA();
        SymbolListTest.assertNotNull((Object)arrayAlpha);
        SymbolListTest.assertNotNull((Object)symListAlpha);
        SymListFactory factory = new SymListFactory(){

            @Override
            public SymbolList createSymbolList(Symbol[] array, FiniteAlphabet alpha, int length) {
                try {
                    Packing pack = PackingFactory.getPacking(DNATools.getDNA(), true);
                    Assert.assertNotNull((Object)pack);
                    Assert.assertNotNull((Object)array);
                    Assert.assertNotNull((Object)alpha);
                    Assert.assertTrue((length > 0 ? 1 : 0) != 0);
                    return new PackedSymbolList(pack, array, length, alpha);
                }
                catch (IllegalAlphabetException iae) {
                    iae.printStackTrace();
                    return null;
                }
            }
        };
        SymbolListTest.assertTrue((boolean)this.runRepeatedSymbolListTests(arrayAlpha, symListAlpha, factory));
    }

    public void testSimpleSymbolListWithAmbiguitySymbols() throws Exception {
        FiniteAlphabet symListAlpha = DNATools.getDNA();
        FiniteAlphabet arrayAlpha = this.generateAmbiguousDNA();
        SymbolListTest.assertNotNull((Object)arrayAlpha);
        SymbolListTest.assertNotNull((Object)symListAlpha);
        SymListFactory factory = new SymListFactory(){

            @Override
            public SymbolList createSymbolList(Symbol[] array, FiniteAlphabet alpha, int length) {
                Assert.assertNotNull((Object)array);
                Assert.assertNotNull((Object)alpha);
                Assert.assertTrue((length > 0 ? 1 : 0) != 0);
                return new SimpleSymbolList(array, length, alpha);
            }
        };
        SymbolListTest.assertTrue((boolean)this.runRepeatedSymbolListTests(arrayAlpha, symListAlpha, factory));
    }

    public void testPackedSymbolListWithoutAmbiguitySymbols() throws Exception {
        FiniteAlphabet symListAlpha = DNATools.getDNA();
        SymbolListTest.assertNotNull((Object)symListAlpha);
        SymListFactory factory = new SymListFactory(){

            @Override
            public SymbolList createSymbolList(Symbol[] array, FiniteAlphabet alpha, int length) {
                try {
                    Packing pack = PackingFactory.getPacking(DNATools.getDNA(), false);
                    Assert.assertNotNull((Object)pack);
                    Assert.assertNotNull((Object)array);
                    Assert.assertNotNull((Object)alpha);
                    Assert.assertTrue((length > 0 ? 1 : 0) != 0);
                    return new PackedSymbolList(pack, array, length, alpha);
                }
                catch (IllegalAlphabetException iae) {
                    iae.printStackTrace();
                    return null;
                }
            }
        };
        SymbolListTest.assertTrue((boolean)this.runRepeatedSymbolListTests(symListAlpha, symListAlpha, factory));
    }

    public void testChunkedPackedSymbolListWithAmbiguitySymbols() throws Exception {
        FiniteAlphabet symListAlpha = DNATools.getDNA();
        FiniteAlphabet arrayAlpha = this.generateAmbiguousDNA();
        SymbolListTest.assertNotNull((Object)arrayAlpha);
        SymbolListTest.assertNotNull((Object)symListAlpha);
        SymListFactory factory = new SymListFactory(){

            @Override
            public SymbolList createSymbolList(Symbol[] array, FiniteAlphabet alpha, int length) {
                Assert.assertNotNull((Object)array);
                Assert.assertNotNull((Object)alpha);
                Assert.assertTrue((length > 0 ? 1 : 0) != 0);
                try {
                    ChunkedSymbolListFactory chunker = new ChunkedSymbolListFactory(new PackedSymbolListFactory(true));
                    chunker.addSymbols(alpha, array, 0, length);
                    return chunker.makeSymbolList();
                }
                catch (IllegalAlphabetException iae) {
                    return null;
                }
            }
        };
        SymbolListTest.assertTrue((boolean)this.runRepeatedSymbolListTests(arrayAlpha, symListAlpha, factory));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SymbolListTest.class);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SymbolListTest.suite());
    }

    private static interface SymListFactory {
        public SymbolList createSymbolList(Symbol[] var1, FiniteAlphabet var2, int var3);
    }
}

