/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.EmptySymbolList;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.OrderNSymbolList;
import org.biojava.bio.symbol.ReverseSymbolList;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SubList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.TranslatedSymbolList;
import org.biojava.bio.symbol.TranslationTable;
import org.biojava.bio.symbol.WindowedSymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

public final class SymbolListViews {
    private SymbolListViews() {
    }

    public static SymbolList orderNSymbolList(SymbolList source, int order) throws IllegalAlphabetException {
        if (order == 1) {
            return source;
        }
        return new OrderNSymbolList(source, order);
    }

    public static SymbolList windowedSymbolList(SymbolList source, int wsize) throws IllegalArgumentException {
        return new WindowedSymbolList(source, wsize);
    }

    public static SymbolList reverse(SymbolList symbols) {
        return new ReverseSymbolList(symbols);
    }

    public static SymbolList translate(SymbolList symbols, TranslationTable table) throws IllegalAlphabetException {
        return new TranslatedSymbolList(symbols, table);
    }

    public static Alignment alignment(Map labelToSymList) throws IllegalArgumentException {
        return new SimpleAlignment(labelToSymList);
    }

    public static Alignment alignment(List labels, SymbolList symList) throws IllegalArgumentException {
        return new SymListAsAlignment(labels, symList);
    }

    public static SymbolList subList(SymbolList parent, int start, int end) throws IllegalArgumentException {
        if (start < 1 || end > parent.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + parent.length() + ":" + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
        }
        return new SubList(parent, start, end);
    }

    public static SymbolList emptyList(Alphabet alpha) {
        return new EmptySymbolList(alpha);
    }

    private static class IndexedSymbolList
    extends AbstractSymbolList {
        private final int indx;
        private final SymbolList symList;

        public IndexedSymbolList(SymbolList symList, int indx) throws IllegalArgumentException {
            if (indx >= symList.getAlphabet().getAlphabets().size()) {
                throw new IllegalArgumentException("index too high");
            }
            this.indx = indx;
            this.symList = symList;
        }

        @Override
        public Alphabet getAlphabet() {
            return (Alphabet)this.symList.getAlphabet().getAlphabets().get(this.indx);
        }

        @Override
        public int length() {
            return this.symList.length();
        }

        @Override
        public Symbol symbolAt(int indx) throws IndexOutOfBoundsException {
            return (Symbol)((BasisSymbol)this.symList.symbolAt(indx)).getSymbols().get(this.indx);
        }
    }

    private static class SymListAsAlignment
    extends Unchangeable
    implements Alignment {
        private final SymbolList symList;
        private final List labels;

        public SymListAsAlignment(List labels, SymbolList symList) {
            if (labels.size() != symList.getAlphabet().getAlphabets().size()) {
                throw new IllegalArgumentException("There must be one label per symbol list");
            }
            this.labels = Collections.unmodifiableList(new ArrayList(labels));
            this.symList = symList;
        }

        @Override
        public List getLabels() {
            return this.labels;
        }

        public SequenceIterator sequenceIterator() {
            throw new UnsupportedOperationException("This method sucks");
        }

        @Override
        public Iterator symbolListIterator() {
            return new Alignment.SymbolListIterator(this);
        }

        @Override
        public Symbol symbolAt(Object label, int column) {
            BasisSymbol sym = (BasisSymbol)this.symList.symbolAt(column);
            return (Symbol)sym.getSymbols().get(this.labels.indexOf(label));
        }

        @Override
        public SymbolList symbolListForLabel(Object label) {
            return new IndexedSymbolList(this.symList, this.labels.indexOf(label));
        }

        @Override
        public Alphabet getAlphabet() {
            return this.symList.getAlphabet();
        }

        @Override
        public Iterator iterator() {
            return this.symList.iterator();
        }

        @Override
        public int length() {
            return this.symList.length();
        }

        @Override
        public String seqString() {
            return this.symList.seqString();
        }

        @Override
        public SymbolList subList(int start, int end) throws IndexOutOfBoundsException {
            return this.symList.subList(start, end);
        }

        @Override
        public String subStr(int start, int end) throws IndexOutOfBoundsException {
            return this.symList.subStr(start, end);
        }

        @Override
        public void edit(Edit edit) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException {
            this.symList.edit(edit);
        }

        @Override
        public List toList() {
            return this.symList.toList();
        }

        @Override
        public Symbol symbolAt(int indx) throws IndexOutOfBoundsException {
            return this.symList.symbolAt(indx);
        }

        @Override
        public Alignment subAlignment(Set labels, Location loc) {
            throw new UnsupportedOperationException("Fixme: this needs to be implemented");
        }
    }
}

