/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.Symbol;

public class SymbolSerializationTest
extends TestCase {
    public SymbolSerializationTest(String name) {
        super(name);
    }

    private void doSymbolTest(Symbol s) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(s);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
        Symbol s2 = (Symbol)ois.readObject();
        ois.close();
        SymbolSerializationTest.assertTrue((s == s2 ? 1 : 0) != 0);
    }

    public void testAtomic() throws Exception {
        this.doSymbolTest(DNATools.t());
    }

    public void testAmbiguous() throws Exception {
        this.doSymbolTest(DNATools.n());
    }

    public void testSpecialGap() throws Exception {
        this.doSymbolTest(AlphabetManager.getGapSymbol());
    }

    public void testCompoundGap() throws Exception {
        List<Alphabet> alphas = Arrays.asList(DNATools.getDNA(), DNATools.getDNA());
        this.doSymbolTest(AlphabetManager.getGapSymbol(alphas));
    }

    public void testNormalGap() throws Exception {
        this.doSymbolTest(DNATools.getDNA().getGapSymbol());
    }
}

