/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.SoftMaskedAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ListTools;

public class TestSoftMaskedAlphabet
extends TestCase {
    private SoftMaskedAlphabet softMaskedAlphabet = null;
    private AtomicSymbol masked;
    private AtomicSymbol unmasked;

    protected void setUp() throws Exception {
        super.setUp();
        this.softMaskedAlphabet = SoftMaskedAlphabet.getInstance(DNATools.getDNA());
        this.masked = (AtomicSymbol)this.softMaskedAlphabet.getSymbol(new ListTools.Doublet(DNATools.a(), IntegerAlphabet.getInstance().getSymbol(1)));
        this.unmasked = (AtomicSymbol)this.softMaskedAlphabet.getSymbol(new ListTools.Doublet(DNATools.a(), IntegerAlphabet.getInstance().getSymbol(0)));
    }

    protected void tearDown() throws Exception {
        this.softMaskedAlphabet = null;
        this.masked = null;
        this.unmasked = null;
        super.tearDown();
    }

    public void testAddSymbol() {
        AtomicSymbol s = DNATools.a();
        try {
            this.softMaskedAlphabet.addSymbol(s);
        }
        catch (ChangeVetoException ex) {
            return;
        }
        TestSoftMaskedAlphabet.fail((String)"Should have thrown an exception");
    }

    public void testContains() {
        TestSoftMaskedAlphabet.assertTrue((boolean)this.softMaskedAlphabet.contains(this.masked));
        TestSoftMaskedAlphabet.assertTrue((boolean)this.softMaskedAlphabet.contains(this.unmasked));
    }

    public void testGetAlphabets() {
        FiniteAlphabet expectedReturn = null;
        Alphabet actualReturn = null;
        List l = this.softMaskedAlphabet.getAlphabets();
        TestSoftMaskedAlphabet.assertTrue((l.size() == 2 ? 1 : 0) != 0);
        expectedReturn = DNATools.getDNA();
        TestSoftMaskedAlphabet.assertTrue((boolean)(l.get(0) instanceof Alphabet));
        actualReturn = (Alphabet)l.get(0);
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
        expectedReturn = IntegerAlphabet.getSubAlphabet(0, 1);
        TestSoftMaskedAlphabet.assertTrue((boolean)(l.get(1) instanceof Alphabet));
        actualReturn = (Alphabet)l.get(1);
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testGetAmbiguity() {
        Set s = null;
        try {
            Symbol actualReturn = this.softMaskedAlphabet.getAmbiguity(s);
            actualReturn = actualReturn == null ? null : actualReturn;
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        TestSoftMaskedAlphabet.fail((String)"Should have thrown and UnsupportedOperationException");
    }

    public void testGetAnnotation() {
        TestSoftMaskedAlphabet.assertNotNull((Object)this.softMaskedAlphabet.getAnnotation());
    }

    public void testGetGapSymbol() {
        Symbol expectedReturn = AlphabetManager.getGapSymbol(this.softMaskedAlphabet.getAlphabets());
        Symbol actualReturn = this.softMaskedAlphabet.getGapSymbol();
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testGetMaskedAlphabet() {
        FiniteAlphabet expectedReturn = DNATools.getDNA();
        FiniteAlphabet actualReturn = this.softMaskedAlphabet.getMaskedAlphabet();
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testGetMaskingDetector() {
        SoftMaskedAlphabet.MaskingDetector expectedReturn = SoftMaskedAlphabet.MaskingDetector.DEFAULT;
        SoftMaskedAlphabet.MaskingDetector actualReturn = this.softMaskedAlphabet.getMaskingDetector();
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "Softmasked {DNA}";
        String actualReturn = this.softMaskedAlphabet.getName();
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (String)expectedReturn, (String)actualReturn);
    }

    public void testGetSymbol() throws IllegalSymbolException {
        ListTools.Doublet l = new ListTools.Doublet(DNATools.g(), IntegerAlphabet.getInstance().getSymbol(1));
        Symbol expectedReturn = this.softMaskedAlphabet.getDelegate().getSymbol(l);
        Symbol actualReturn = this.softMaskedAlphabet.getSymbol(l);
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testGetTokenization() throws BioException {
        String type = "token";
        SymbolTokenization actualReturn = this.softMaskedAlphabet.getTokenization(type);
        TestSoftMaskedAlphabet.assertNotNull((Object)actualReturn);
        TestSoftMaskedAlphabet.assertTrue((boolean)(actualReturn instanceof SoftMaskedAlphabet.CaseSensitiveTokenization));
    }

    public void testTokenizeSymbol() throws BioException {
        SymbolTokenization st = this.softMaskedAlphabet.getTokenization("token");
        TestSoftMaskedAlphabet.assertEquals((Object)this.softMaskedAlphabet, (Object)st.getAlphabet());
        AtomicSymbol s = null;
        s = (AtomicSymbol)st.parseToken("a");
        TestSoftMaskedAlphabet.assertTrue((boolean)this.softMaskedAlphabet.isMasked(s));
        TestSoftMaskedAlphabet.assertEquals((String)"a", (String)st.tokenizeSymbol(s));
        s = (AtomicSymbol)st.parseToken("c");
        TestSoftMaskedAlphabet.assertTrue((boolean)this.softMaskedAlphabet.isMasked(s));
        TestSoftMaskedAlphabet.assertEquals((String)"c", (String)st.tokenizeSymbol(s));
        s = (AtomicSymbol)st.parseToken("g");
        TestSoftMaskedAlphabet.assertTrue((boolean)this.softMaskedAlphabet.isMasked(s));
        TestSoftMaskedAlphabet.assertEquals((String)"g", (String)st.tokenizeSymbol(s));
        s = (AtomicSymbol)st.parseToken("t");
        TestSoftMaskedAlphabet.assertTrue((boolean)this.softMaskedAlphabet.isMasked(s));
        TestSoftMaskedAlphabet.assertEquals((String)"t", (String)st.tokenizeSymbol(s));
        s = (AtomicSymbol)st.parseToken("A");
        TestSoftMaskedAlphabet.assertTrue((!this.softMaskedAlphabet.isMasked(s) ? 1 : 0) != 0);
        TestSoftMaskedAlphabet.assertEquals((String)"A", (String)st.tokenizeSymbol(s));
        s = (AtomicSymbol)st.parseToken("C");
        TestSoftMaskedAlphabet.assertTrue((!this.softMaskedAlphabet.isMasked(s) ? 1 : 0) != 0);
        TestSoftMaskedAlphabet.assertEquals((String)"C", (String)st.tokenizeSymbol(s));
        s = (AtomicSymbol)st.parseToken("G");
        TestSoftMaskedAlphabet.assertTrue((!this.softMaskedAlphabet.isMasked(s) ? 1 : 0) != 0);
        TestSoftMaskedAlphabet.assertEquals((String)"G", (String)st.tokenizeSymbol(s));
        s = (AtomicSymbol)st.parseToken("T");
        TestSoftMaskedAlphabet.assertTrue((!this.softMaskedAlphabet.isMasked(s) ? 1 : 0) != 0);
        TestSoftMaskedAlphabet.assertEquals((String)"T", (String)st.tokenizeSymbol(s));
    }

    public void testTokenization() throws IllegalSymbolException, BioException {
        String seqString = "actgATGC";
        SimpleSymbolList sl = new SimpleSymbolList(this.softMaskedAlphabet.getTokenization("token"), seqString);
        TestSoftMaskedAlphabet.assertEquals((String)seqString, (String)sl.seqString());
    }

    public void testIsMasked() throws IllegalSymbolException {
        ListTools.Doublet a = new ListTools.Doublet(DNATools.g(), IntegerAlphabet.getInstance().getSymbol(1));
        ListTools.Doublet b = new ListTools.Doublet(DNATools.g(), IntegerAlphabet.getInstance().getSymbol(0));
        AtomicSymbol s = (AtomicSymbol)this.softMaskedAlphabet.getSymbol(a);
        boolean expectedReturn = true;
        boolean actualReturn = this.softMaskedAlphabet.isMasked(s);
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
        s = (AtomicSymbol)this.softMaskedAlphabet.getSymbol(b);
        expectedReturn = false;
        actualReturn = this.softMaskedAlphabet.isMasked(s);
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testIterator() {
        Iterator i = this.softMaskedAlphabet.iterator();
        int count = 0;
        while (i.hasNext()) {
            TestSoftMaskedAlphabet.assertTrue((boolean)(i.next() instanceof AtomicSymbol));
            ++count;
        }
        TestSoftMaskedAlphabet.assertTrue((count == 8 ? 1 : 0) != 0);
    }

    public void testRemoveSymbol() {
        Symbol s = null;
        try {
            this.softMaskedAlphabet.removeSymbol(s);
        }
        catch (ChangeVetoException ex) {
            return;
        }
        TestSoftMaskedAlphabet.fail((String)"Should have thrown ChangeVetoException");
    }

    public void testSize() {
        int expectedReturn = 8;
        int actualReturn = this.softMaskedAlphabet.size();
        TestSoftMaskedAlphabet.assertEquals((String)"return value", (int)expectedReturn, (int)actualReturn);
    }

    public void testValidate() {
        Iterator iter = this.softMaskedAlphabet.iterator();
        while (iter.hasNext()) {
            Symbol s = (Symbol)iter.next();
            try {
                this.softMaskedAlphabet.validate(s);
            }
            catch (IllegalSymbolException ex) {
                TestSoftMaskedAlphabet.fail((String)("Symbol " + s.getName() + " not a valid member of this alphabet"));
            }
        }
    }
}

