/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.symbol.SymbolList;

public class TranslationTest
extends TestCase {
    private SymbolList dnaForm;
    private SymbolList rnaForm;
    private SymbolList pepForm;

    public TranslationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.dnaForm = DNATools.createDNA("tttcctgtc");
        this.rnaForm = RNATools.createRNA("uuuccuguc");
        this.pepForm = ProteinTools.createProtein("FPV");
    }

    public void testTranscribe() throws Exception {
        TranslationTest.assertTrue((boolean)this.compareSymbolList(RNATools.transcribe(this.dnaForm), this.rnaForm));
    }

    public void testTranslate() throws Exception {
        TranslationTest.assertTrue((boolean)this.compareSymbolList(RNATools.translate(this.rnaForm), this.pepForm));
    }

    private boolean compareSymbolList(SymbolList sl1, SymbolList sl2) {
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator si1 = sl1.iterator();
        Iterator si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }
}

