/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.UkkonenSuffixTree;

public class UkkonenSuffixTreeTest
extends TestCase {
    UkkonenSuffixTree test;
    String mississippi = "mississippi";
    private String dna = "GGCTCAGTCCCGACGTGGAACTCAGCAGCGGAGGCTGGACGCTTGCATGGCGCTTGAGGCAAGTTCGGGGCTCATTTTGGAAGTTTTCTTTCTAGCACAGACATCCAACTCTGCTCCTATGCCAGTCAGATAATTAAGGAATTAAGTAATAATTGTGCTCTGCAAATTATGATAGTGATCTGTATTTACTACGTGCATATATTTTGGGCCAGTGAATTTTTTTCTAAGCTAATATAGTTATTTGGACTTTTGACATGACTTTGTGTTTAATTAAAACAAAAAAAGAAATTGCAGAAGTGTTGTAAGCTTGTAAAAAAATTCAAACAATGCAGACAAATGTGTCTCGCAGTCTTCCACTCAGTATCATTTTTGTTTGTACCTTATCAGAAATGTTTCTATGTACAAGTCTTTAAAATCATTTCGAACTTGCTTTGTCCACTGAGTATATTATGGACATCTTTTCATGGCAGGACATATAGATGTGTTAATGGCATTAAAAATAAAACAAAAAACTGATTCGGCCGGGTACGGTGGCTCACGCCTGTAATCCCAGCACTTTGGGAGATCGAGGAGGGAGGATCACCTGAGGTCAGGAGTTACAGACATGGAGAAACCCCGTCTCTACTAAAAATACAAAATTAGCCTGGCGTGGTGGCGCATGCCTGTAATCCCAGCTACTCGGGAGGCTGAGGCAGGAGAATCGCTTGAACCCGGGAGCGGAGGTTGCGGTGAGCCGAGATCGCACCGTTGCACTCCAGCCTGGGCGACAGAGCGAAACTGTCTCAAACAAACAAACAAAAAAACCTGATACATGGTATGGGAAGTACATTGTTTAAACAATGCATGGAGATTTAGGTTGTTTCCAGTTTTTACTGGCACAGATACGGCAATGAATATAATTTTATGTATACATTCATACAAATATATCGGTGGAAAATTCCTAGAAGTGGAATGGCTGGGTCAGTGGGCATTCATATTGAGAAATTGGAAGGATGTTGTCAAACTCTGCAAATCAGAGTATTTTAGTCTTAACCTCTCTTCTTCACACCCTTTTCCTTGGAAGAAAGCTAAATTTAGACTTTTAAACACAAAACTCCATTTTGAGACCCCTGAAAATCTGGGTTCAAAGTGTTTGAAAATTAAAGCAGAGGCTTTAATTTGTACTTATTTAGGTATAATTTGTACTTTAAAGTTGTTCCAGAAAACAAGGCAAATACTGAAAAGCATTTCATCTGAAGTTTCTTTCTGGTATTGAACAGAGTTGGATGGAGAGTGAATGCAGGTTACCGATGTGTTCGCAGGAACAAAACGGGAGGGAGAGTAACACAGGTGCACGGCTTCATATTGATTTATCAAAGAACTTGCTTTTGGACTGTTAAAAAATGTGTTGCACAGTTCTGACACTTTTACACAATGATGAGCTTACAAAGGGGAAAATGCTTAACATAAACATAGTTTCAAAGAAGGTAAGTCCTAGTTTTTCCACGAGCTGTTTTTTTTTTTGAGAGAGAGTAGTCCCAAAATTTCCCTATTATGTGGTTTTTCATCCAAAGTGTTGTAATCCGTGTGTTCTAACCCGCATATTACGATTACTCAAGAAATGCAAAATAGGCCGGGCGCGGTGGCTCACGCCTGTAATCCCAGCAATTTGGGAGGCCGAGGCAGGTGGATCACGAGGTCAGGAGATCAAGACCATCCTAGCTAACACGGTGCAAACCCATCTACTAAAAATAAAAAATATTAGCTGGGCGTGGCGGCAGGCGCCTGTAGTCCCAACTACTCGGGAGGCTGAGGCAGGAGAATGGCGTGAACCTGGGAGGCGGAGCTTGCAGTGAGCCAAGATCCGGCCACTGCACTCCAGCCTGGGCGACAGAGGGAGACTCCGTCTCAAAAATAAAAATAAAAATAAAAAAAGAAAAAAGAAATGCAAAATAATGTGAACACGTCATCGAGACTGCGGTCTACAATTGTGGTTGCCATGATGGGGTGGGTCGGAAGACACCGAGGCTGCTTGAATCATGTTCCTGGCAGGTTAATTTTGTTCCTTTTAGGGCATCTAAATGTTGGAGTTGGCTTTCCTGGCAGAGAGTCCAGTTGTGAGTGGAGTATTGGGTGGAGGCCCCACCCTCCCCAGGTTTTCTGCAGCTTGTTCCTGGCTCTTCTGGGGCTTCTCTGAGGACCCCGATTGGTCCTGGGGCTTCTTTAGTGGTGGGCCTGGGCCAGTTCCTTCCGTTGCTCACCTCTCCCCGAAGCTTAAGGATAACATTTCGGGAAGATCATGAGAGAACGTGAACCAAAAAAAAAAAAAAAAATTCAGGTAGGGTGGGAGCTAAGTTAGTTTAGTATTTGGGATTTTTGTTTTGTTTTGTTTGAGACAGAGTCTCAAACAAAGACCCCGCGCCTGGCCTGGGGGTCTTTTTTTGAGTCAGCAGTTGAGTTTGAAAATCCCCTTCCTTGGAATCCGCCCAGGCTGTTTTCTCTGGTGGATGCTTATTGCCCCTGCTAACTTCAGCTGCGGTCTCTCTGCTCGCCTTGCCCTCCCCATCCTCCTTAGACCTTTTAAGCTTCACTTTCCTTTCCTTGCTGCCCCGCCTCCCTGTCTCCCCAGTGTGATCTACCCTGAAAGGCTGCTGTATTTTGTTTCCCTTTGGGACCGAGCCTGCTCAAATGATCTGCTCCATGAGGTTTTACTGCTATATCCTACTGAAGTATCTGGGAGGTCTTGGCGGAGAAGAGGACAACATCTTGGAAAATGCAGCCTGGAACCTCTCTGCTCTCTTTCATCAGCTTTCCCTCAATGATGAGCTCAAAATCCTCTTTCTTGCTGATGGAATTGTCTGCTGTCATCATTTCAGTTGAGTCCTCCTAGGCTGGGCCTTGTAAGAAGAACAACTGTTTATAACTATTGAAAGTCAATATTTACTAAGAAAAAGAGGTTGTTGTTATCTGAGCCATCCAACATGAATTTAAGAATATATTCCAGGCTGGGCGCGGTGGCTCATGCCTGTAATCCCAGCACTTTGGGAGGCCGAGATGGGTGGATCACCTGAGGTCAGGAGTTCAAGACCAGCCTGGCCAACATGGTGAAACCCCGTCTCTACTAAAAATACAAAAATTAGCCATGCGTGGTGGCACATGCCTGTAGTTCCAACTATTTGGGACACTAAGGCAGGGGAAGTGCTTGAACTCGGGAGGCAGAGGTTGCAGTGAGCTGAGATTGTACCACTGCACTCCAGCCTGGGTAAAAAGAGTGAAATTCCATCTCAAAAAAAAAAAAGGAGACAGGGTCTTGCCCTGTTGCCCAGGCTGGAGTGCCGTGGCACGATCATAACTCACTGTGGCCTCAAATTCCTGGGCTCAACTGATTCTCCTGCCTCAGTCTCCCAAGTAGCTGGGACCACAAGTACATGCCACCATGCTAGGCTAATTTTATTTTTATTTTTAGAAAATAAAATATTTTTTATTTTATTTAGGCAACATGCTATGTTGCCTAGACTGGTCTTGAACTCCTGGCTTCAAGCTATCCTCTTGCCTCAGCCAACCAAAGTGCTGGGATTGCAGGTGTGAACTGCCATGCCTGGCTTTCTATTCTCTATTTCTAGGAGATAAGCTTTTTGAGCTTTCACATATGAGTGTGAACATGTGGTATTTATCTTTCTGTGCCTAGGTTATTCCACTTAACGTAATGTACTCCAGGCTCATCCATGTTGATGGGAATTACAGGATTTCATTCTCTTGTAATGGCTGAATAACATCCCATTTTGTGTATATAGTCCACATGTTCTTTATCCATTCCTCTTTTGATAGACACTTAGGTTGATTCCGTATCTCGGGTATTATGAGCAGTGCTGCAGTAAACATGAGAGTGCAAATATCTCTTCAACATACTGATTCCCTTTCCTTTGGATATATATTCAGCAGT";

    public UkkonenSuffixTreeTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.test = new UkkonenSuffixTree();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(UkkonenSuffixTreeTest.class));
    }

    public void testMultiple() {
        try {
            new UkkonenSuffixTree(this.mississippi + "$" + this.mississippi);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void testNumberNodes() {
        this.test.addSequence(this.mississippi, "name", false);
        UkkonenSuffixTreeTest.assertEquals((int)19, (int)this.test.getAllNodes(this.test.getRoot(), null, false).size());
        UkkonenSuffixTreeTest.assertEquals((int)12, (int)this.test.getAllNodes(this.test.getRoot(), null, true).size());
    }

    public void testSymbolListAddition() {
        SymbolList here = null;
        try {
            here = DNATools.createDNA("taccaccagga");
            this.test = new UkkonenSuffixTree((FiniteAlphabet)here.getAlphabet());
            this.test.addSymbolList(here, "name", false);
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
        UkkonenSuffixTreeTest.assertEquals((int)19, (int)this.test.getAllNodes(this.test.getRoot(), null, false).size());
        UkkonenSuffixTreeTest.assertEquals((int)12, (int)this.test.getAllNodes(this.test.getRoot(), null, true).size());
    }

    public void testDuplicateAddition() {
        this.test.addSequence(this.mississippi, "name", false);
        this.test.addSequence(this.mississippi, "name", false);
        UkkonenSuffixTreeTest.assertEquals((int)19, (int)this.test.getAllNodes(this.test.getRoot(), null, false).size());
        UkkonenSuffixTreeTest.assertEquals((int)12, (int)this.test.getAllNodes(this.test.getRoot(), null, true).size());
    }

    public void testGetterMethods() {
        SymbolList here = null;
        try {
            here = DNATools.createDNA("taccaccagga");
            this.test = new UkkonenSuffixTree((FiniteAlphabet)here.getAlphabet());
            this.test.addSymbolList(here, "name", false);
        }
        catch (IllegalSymbolException e) {
            e.printStackTrace();
        }
        UkkonenSuffixTreeTest.assertTrue((this.test.getRoot().getParent() == null ? 1 : 0) != 0);
        UkkonenSuffixTreeTest.assertTrue((boolean)this.test.getRoot().hasChild(new Character('g')));
        UkkonenSuffixTreeTest.assertTrue((boolean)this.test.getRoot().getChild(new Character('$')).isTerminal());
    }

    public void testlongAddition() {
        this.test.addSequence(this.dna, "name", false);
        int before = this.test.getAllNodes(this.test.getRoot(), null, false).size();
        this.test.addSequence(this.dna, "name", false);
        int after = this.test.getAllNodes(this.test.getRoot(), null, false).size();
        UkkonenSuffixTreeTest.assertEquals((int)before, (int)after);
    }
}

