/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.biojava.directory.OBDARegistryParser;
import org.biojava.directory.RegistryConfiguration;

public class OBDARegistryParserTest
extends TestCase {
    public OBDARegistryParserTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParseRegistry() throws Exception {
        RegistryConfiguration regConf = null;
        BufferedReader br = null;
        String locator = "<locator>";
        try {
            br = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("seqdatabase.ini")));
            regConf = OBDARegistryParser.parseRegistry(br, locator);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        OBDARegistryParserTest.assertNotNull((Object)regConf);
        OBDARegistryParserTest.assertEquals((String)locator, (String)regConf.getConfigLocator());
        Map conf = regConf.getConfiguration();
        OBDARegistryParserTest.assertTrue((boolean)conf.containsKey("databank_0"));
        OBDARegistryParserTest.assertTrue((boolean)conf.containsKey("databank_1"));
        List dbConfigs = (List)conf.get("databank_0");
        OBDARegistryParserTest.assertEquals((int)1, (int)dbConfigs.size());
        Map dbConfig = (Map)dbConfigs.get(0);
        OBDARegistryParserTest.assertEquals((Object)"<protocol-type 0>", dbConfig.get("protocol"));
        OBDARegistryParserTest.assertEquals((Object)"<location-string 0>", dbConfig.get("location"));
        dbConfigs = (List)conf.get("databank_1");
        OBDARegistryParserTest.assertEquals((int)2, (int)dbConfigs.size());
        dbConfig = (Map)dbConfigs.get(0);
        OBDARegistryParserTest.assertEquals((Object)"<protocol-type 1a>", dbConfig.get("protocol"));
        OBDARegistryParserTest.assertEquals((Object)"<location-string 1a>", dbConfig.get("location"));
        dbConfig = (Map)dbConfigs.get(1);
        OBDARegistryParserTest.assertEquals((Object)"<protocol-type 1b>", dbConfig.get("protocol"));
        OBDARegistryParserTest.assertEquals((Object)"<location-string 1b>", dbConfig.get("location"));
    }
}

