/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.biojava.directory.RegistryConfiguration;

public class RegistryConfigurationTest
extends TestCase {
    protected Map confParams0;
    protected Map confParams1;
    protected Map confParams2;
    protected String locator0;
    protected String locator1;
    protected String locator2;

    public RegistryConfigurationTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.confParams0 = new HashMap();
        this.confParams0.put("protocol", "<protocol-type 0>");
        this.confParams0.put("location", "<location-string 0>");
        this.confParams0.put("parameter-x", "<value 0>");
        this.confParams1 = new HashMap();
        this.confParams1.put("protocol", "<protocol-type 1>");
        this.confParams1.put("location", "<location-string 1>");
        this.confParams1.put("parameter-y", "<value 1>");
        this.confParams2 = new HashMap();
        this.confParams2.put("protocol", "<protocol-type 2>");
        this.confParams2.put("location", "<location-string 2>");
        this.confParams2.put("parameter-x", "<value 2>");
        this.locator0 = "<locator0>";
        this.locator1 = "<locator1>";
        this.locator2 = "<locator2>";
    }

    public void testSimpleRegistry() throws Exception {
        HashMap<String, Map> conf0 = new HashMap<String, Map>();
        conf0.put("databank_0", this.confParams0);
        RegistryConfiguration.Impl simple = new RegistryConfiguration.Impl(this.locator0, conf0);
        RegistryConfigurationTest.assertEquals((String)this.locator0, (String)simple.getConfigLocator());
        RegistryConfigurationTest.assertEquals(conf0, (Object)simple.getConfiguration());
    }

    public void testCompositeRegistry() throws Exception {
        RegistryConfiguration.Composite composite = new RegistryConfiguration.Composite();
        HashMap<String, Map> conf0 = new HashMap<String, Map>();
        conf0.put("databank_0", this.confParams0);
        RegistryConfiguration.Impl simple0 = new RegistryConfiguration.Impl(this.locator0, conf0);
        HashMap<String, Map> conf1 = new HashMap<String, Map>();
        conf1.put("databank_0", this.confParams1);
        RegistryConfiguration.Impl simple1 = new RegistryConfiguration.Impl(this.locator1, conf1);
        HashMap<String, Map> conf2 = new HashMap<String, Map>();
        conf2.put("databank_0", this.confParams2);
        RegistryConfiguration.Impl simple2 = new RegistryConfiguration.Impl(this.locator2, conf2);
        composite.addTopConfig(simple0);
        RegistryConfigurationTest.assertEquals((String)this.locator0, (String)composite.getConfigLocator());
        RegistryConfigurationTest.assertEquals((Object)"<protocol-type 0>", ((Map)composite.getConfiguration().get("databank_0")).get("protocol"));
        RegistryConfigurationTest.assertEquals((Object)"<location-string 0>", ((Map)composite.getConfiguration().get("databank_0")).get("location"));
        composite.addBottomConfig(simple1);
        RegistryConfigurationTest.assertEquals((String)(this.locator0 + "::" + this.locator1), (String)composite.getConfigLocator());
        RegistryConfigurationTest.assertEquals((Object)"<protocol-type 0>", ((Map)composite.getConfiguration().get("databank_0")).get("protocol"));
        RegistryConfigurationTest.assertEquals((Object)"<location-string 0>", ((Map)composite.getConfiguration().get("databank_0")).get("location"));
        composite.addTopConfig(simple2);
        RegistryConfigurationTest.assertEquals((String)(this.locator2 + "::" + this.locator0 + "::" + this.locator1), (String)composite.getConfigLocator());
        RegistryConfigurationTest.assertEquals((Object)"<protocol-type 2>", ((Map)composite.getConfiguration().get("databank_0")).get("protocol"));
        RegistryConfigurationTest.assertEquals((Object)"<location-string 2>", ((Map)composite.getConfiguration().get("databank_0")).get("location"));
        RegistryConfigurationTest.assertEquals((Object)"<value 2>", ((Map)composite.getConfiguration().get("databank_0")).get("parameter-x"));
        RegistryConfigurationTest.assertNull(((Map)composite.getConfiguration().get("databank_0")).get("parameter-y"));
    }
}

