/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.util.List;
import junit.framework.TestCase;
import org.biojava.directory.Registry;
import org.biojava.directory.SystemRegistry;

public class SystemRegistryTest
extends TestCase {
    public SystemRegistryTest(String name) {
        super(name);
    }

    public void testInstance() throws Exception {
        Registry registry = SystemRegistry.instance();
        SystemRegistryTest.assertNotNull((Object)registry);
    }

    public void testGetRegistryPath() {
        List registryPath = SystemRegistry.getRegistryPath();
        int numElements = registryPath.size();
        if (numElements < 2 || numElements > 3) {
            SystemRegistryTest.fail((String)("Expected 2 or 3 registry path elements but found " + numElements));
        }
        int offset = 0;
        if (numElements == 3) {
            SystemRegistryTest.assertEquals((Object)("file://" + System.getProperty("user.home") + "/.bioinformatics/seqdatabase.ini"), registryPath.get(0));
            ++offset;
        }
        SystemRegistryTest.assertEquals((Object)"file:///etc/bioinformatics/seqdatabase.ini", registryPath.get(0 + offset));
        SystemRegistryTest.assertEquals((Object)"http://www.open-bio.org/registry/seqdatabase.ini", registryPath.get(1 + offset));
    }
}

