/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.naming;

import java.util.Properties;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import junit.framework.TestCase;

public class ObdaInitialContextFactoryTest
extends TestCase {
    public void testLookup() throws Exception {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "org.biojava.naming.ObdaInitialContextFactory");
        InitialDirContext context = new InitialDirContext(env);
        DirContext embl = (DirContext)context.lookup("urn:open-bio.org:format:embl");
        ObdaInitialContextFactoryTest.assertNotNull((String)"Fetched embl name", (Object)embl);
        Attributes desc = embl.getAttributes("", new String[]{"description"});
        ObdaInitialContextFactoryTest.assertEquals((String)"Got one description attribute", (int)1, (int)desc.size());
        ObdaInitialContextFactoryTest.assertNotNull((String)"Description is not null", (Object)desc.get("description"));
    }

    public void testWalk() throws Exception {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "org.biojava.naming.ObdaInitialContextFactory");
        InitialDirContext context = new InitialDirContext(env);
        this.walk(context);
    }

    private void walk(DirContext context) throws Exception {
        System.out.println("Reached " + context.getNameInNamespace());
        System.out.println("  Attributes: " + context.getAttributes(""));
        NamingEnumeration<Binding> ne = context.listBindings("");
        while (ne.hasMore()) {
            Binding b = (Binding)ne.nextElement();
            System.out.println("Binding: " + b.getName() + " -> " + b.getObject());
            this.walk((DirContext)b.getObject());
        }
    }
}

