/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.naming;

import javax.naming.Name;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.biojava.naming.ObdaUriParser;

public class ObdaUriParserTest
extends TestCase {
    public void testEmpty() throws NamingException {
        Name name = ObdaUriParser.getInstance().parse("");
        System.out.println(name);
        ObdaUriParserTest.assertEquals((String)"Empty string parses to no names", (int)0, (int)name.size());
    }

    public void testSingle() throws NamingException {
        Name name = ObdaUriParser.getInstance().parse("oneName");
        System.out.println(name);
        ObdaUriParserTest.assertEquals((String)"Single part parses to single name", (int)1, (int)name.size());
    }

    public void testLeading() throws NamingException {
        Name name = ObdaUriParser.getInstance().parse(":trail");
        System.out.println(name);
        ObdaUriParserTest.assertEquals((String)"leading part parses double name", (int)2, (int)name.size());
        ObdaUriParserTest.assertEquals((String)"leader is empty", (String)"", (String)name.get(0));
        ObdaUriParserTest.assertEquals((String)"trailer is there", (String)"trail", (String)name.get(1));
    }

    public void testTrailing() throws NamingException {
        Name name = ObdaUriParser.getInstance().parse("lead:");
        System.out.println(name);
        ObdaUriParserTest.assertEquals((String)"trailing part parses double name", (int)2, (int)name.size());
        ObdaUriParserTest.assertEquals((String)"leader is there", (String)"lead", (String)name.get(0));
        ObdaUriParserTest.assertEquals((String)"trailer is empty", (String)"", (String)name.get(1));
    }

    public void testLots() throws NamingException {
        Name name = ObdaUriParser.getInstance().parse("urn:obda.org:format:embl/ac");
        System.out.println(name);
        ObdaUriParserTest.assertEquals((String)"Splits into 4 parts", (int)4, (int)name.size());
        ObdaUriParserTest.assertEquals((String)"part0=urn", (String)"urn", (String)name.get(0));
        ObdaUriParserTest.assertEquals((String)"part1=obda.org", (String)"obda.org", (String)name.get(1));
        ObdaUriParserTest.assertEquals((String)"part2=format", (String)"format", (String)name.get(2));
        ObdaUriParserTest.assertEquals((String)"part3=embl/ac", (String)"embl/ac", (String)name.get(3));
    }
}

