/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.DefaultOps;
import org.biojava.ontology.OntologyOps;
import org.biojava.ontology.OntologyTerm;
import org.biojava.ontology.RemoteTerm;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.ontology.Variable;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public interface Ontology
extends Changeable {
    public static final ChangeType TERM = new ChangeType("A term has been added or removed", "org.biojava.ontology.Ontology", "TERM");
    public static final ChangeType TRIPLE = new ChangeType("A triple has been added or removed", "org.biojava.ontology.Ontology", "TRIPLE");

    public String getName();

    public String getDescription();

    public Set getTerms();

    public Term getTerm(String var1) throws NoSuchElementException;

    public Set getTriples(Term var1, Term var2, Term var3);

    public OntologyOps getOps();

    public Term createTerm(String var1, String var2) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException;

    public Term createTerm(String var1, String var2, Object[] var3) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException;

    public Variable createVariable(String var1, String var2) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException;

    public Term importTerm(Term var1, String var2) throws ChangeVetoException, IllegalArgumentException;

    public Triple createTriple(Term var1, Term var2, Term var3, String var4, String var5) throws AlreadyExistsException, ChangeVetoException;

    public boolean containsTriple(Term var1, Term var2, Term var3);

    public void deleteTerm(Term var1) throws ChangeVetoException;

    public boolean containsTerm(String var1);

    public static final class Impl
    extends AbstractChangeable
    implements Ontology,
    Serializable {
        private final Map terms = new HashMap();
        private final Set triples = new HashSet();
        private final Map subjectTriples = new HashMap();
        private final Map objectTriples = new HashMap();
        private final Map relationTriples = new HashMap();
        private final Map remoteTerms = new HashMap();
        private final Set localRemoteTerms = new HashSet();
        private final String name;
        private final String description;
        private final OntologyOps ops;

        public Impl(String name, String description) {
            this.name = name;
            this.description = description;
            this.ops = new DefaultOps(){

                @Override
                public Set getRemoteTerms() {
                    return Impl.this.localRemoteTerms;
                }
            };
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Set getTerms() {
            return new HashSet(this.terms.values());
        }

        @Override
        public Term getTerm(String name) throws NoSuchElementException {
            Term t = (Term)this.terms.get(name);
            if (t == null) {
                throw new NoSuchElementException("No term named '" + name + "'");
            }
            return (Term)this.terms.get(name);
        }

        @Override
        public Set getTriples(Term subject, Term object, Term predicate) {
            if (subject != null && subject.getOntology() != this) {
                throw new IllegalArgumentException("Subject is not in this ontology: " + subject + " " + this);
            }
            if (object != null && object.getOntology() != this) {
                throw new IllegalArgumentException("Object is not in this ontology: " + object + " " + this);
            }
            if (predicate != null && predicate.getOntology() != this) {
                throw new IllegalArgumentException("Predicate is not in this ontology: " + predicate + " " + this);
            }
            if (subject != null) {
                return this.filterTriples((Set)this.subjectTriples.get(subject), null, object, predicate);
            }
            if (object != null) {
                return this.filterTriples((Set)this.objectTriples.get(object), subject, null, predicate);
            }
            if (predicate != null) {
                return this.filterTriples((Set)this.relationTriples.get(predicate), subject, object, null);
            }
            return this.filterTriples(this.triples, subject, object, predicate);
        }

        private Set filterTriples(Set base, Term subject, Term object, Term predicate) {
            if (base == null) {
                return Collections.EMPTY_SET;
            }
            if (subject == null && object == null && predicate == null) {
                return Collections.unmodifiableSet(new HashSet(base));
            }
            HashSet<Triple> retval = new HashSet<Triple>();
            for (Triple t : base) {
                if (subject != null && t.getSubject() != subject || object != null && t.getObject() != object || predicate != null && t.getPredicate() != predicate) continue;
                retval.add(t);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTerm(Term t) throws AlreadyExistsException, IllegalArgumentException, ChangeVetoException {
            if (this.terms.containsKey(t.getName())) {
                throw new AlreadyExistsException("Ontology " + this.getName() + " already contains " + t.getName());
            }
            if (!this.hasListeners()) {
                this.terms.put(t.getName(), t);
            } else {
                ChangeSupport cs;
                ChangeEvent ce = new ChangeEvent(this, TERM, t, null);
                ChangeSupport changeSupport = cs = this.getChangeSupport(TERM);
                synchronized (changeSupport) {
                    cs.firePreChangeEvent(ce);
                    this.terms.put(t.getName(), t);
                    cs.firePostChangeEvent(ce);
                }
            }
        }

        @Override
        public Term createTerm(String name, String description) throws AlreadyExistsException, IllegalArgumentException, ChangeVetoException {
            Term.Impl t = new Term.Impl(this, name, description);
            this.addTerm(t);
            return t;
        }

        @Override
        public Term createTerm(String name, String description, Object[] synonyms) throws AlreadyExistsException, IllegalArgumentException, ChangeVetoException {
            Term.Impl t = new Term.Impl(this, name, description, synonyms);
            this.addTerm(t);
            return t;
        }

        @Override
        public Variable createVariable(String name, String description) throws AlreadyExistsException, ChangeVetoException, IllegalArgumentException {
            Variable.Impl var = new Variable.Impl(this, name, description);
            this.addTerm(var);
            return var;
        }

        public OntologyTerm createOntologyTerm(Ontology o) throws AlreadyExistsException, ChangeVetoException {
            OntologyTerm.Impl ot = new OntologyTerm.Impl(this, o);
            this.addTerm(ot);
            return ot;
        }

        @Override
        public Term importTerm(Term t, String name) throws IllegalArgumentException, ChangeVetoException {
            while (t instanceof RemoteTerm) {
                t = ((RemoteTerm)t).getRemoteTerm();
            }
            if (t.getOntology() == this) {
                return t;
            }
            RemoteTerm rt = (RemoteTerm)this.remoteTerms.get(t);
            if (rt == null) {
                rt = new RemoteTerm.Impl(this, t, name);
                try {
                    this.addTerm(rt);
                }
                catch (AlreadyExistsException e) {
                    throw new AssertionFailure("This term can not exist", e);
                }
                if (name == null) {
                    this.remoteTerms.put(t, rt);
                }
                this.localRemoteTerms.add(rt);
            }
            return rt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteTerm(Term t) throws ChangeVetoException {
            String name = t.getName();
            if (this.terms.get(name) != t) {
                return;
            }
            if (!this.hasListeners()) {
                this.terms.remove(name);
                if (t instanceof Triple) {
                    this.removeTriple((Triple)t);
                }
            } else {
                ChangeSupport cs;
                ChangeEvent ce = new ChangeEvent(this, TERM, null, t);
                ChangeSupport changeSupport = cs = this.getChangeSupport(TERM);
                synchronized (changeSupport) {
                    cs.firePreChangeEvent(ce);
                    this.terms.remove(name);
                    if (t instanceof Triple) {
                        this.removeTriple((Triple)t);
                    }
                    cs.firePostChangeEvent(ce);
                }
            }
        }

        @Override
        public boolean containsTerm(String name) {
            return this.terms.containsKey(name);
        }

        private boolean containsTerm(Term t) {
            return this.terms.get(t.getName()) == t;
        }

        @Override
        public boolean containsTriple(Term subject, Term object, Term predicate) {
            if (subject.getOntology() != this) {
                return false;
            }
            if (object.getOntology() != this) {
                return false;
            }
            if (predicate.getOntology() != this) {
                return false;
            }
            return this.triples.contains(new Triple.Impl(subject, object, predicate));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Triple createTriple(Term subject, Term object, Term predicate, String name, String description) throws AlreadyExistsException, IllegalArgumentException, ChangeVetoException, NullPointerException, IllegalArgumentException {
            Triple.Impl t = new Triple.Impl(subject, object, predicate, name, description);
            if (!this.containsTerm(subject)) {
                throw new IllegalArgumentException("Ontology " + this.getName() + " doesn't contain " + subject);
            }
            if (!this.containsTerm(predicate)) {
                throw new IllegalArgumentException("Ontology " + this.getName() + " doesn't contain " + predicate);
            }
            if (!this.containsTerm(object)) {
                throw new IllegalArgumentException("Ontology " + this.getName() + " doesn't contain " + object);
            }
            if (this.triples.contains(t)) {
                throw new AlreadyExistsException("Ontology " + this.getName() + " already contains " + ((Object)t).toString());
            }
            if (!this.hasListeners()) {
                this.addTerm(t);
                this.addTriple(t);
            } else {
                ChangeSupport cs;
                ChangeEvent ce = new ChangeEvent(this, TRIPLE, t, null);
                ChangeSupport changeSupport = cs = this.getChangeSupport(TRIPLE);
                synchronized (changeSupport) {
                    cs.firePreChangeEvent(ce);
                    this.addTerm(t);
                    this.addTriple(t);
                    cs.firePostChangeEvent(ce);
                }
            }
            return t;
        }

        private void addTriple(Triple t) {
            this.triples.add(t);
            this.pushTriple(this.subjectTriples, t.getSubject(), t);
            this.pushTriple(this.objectTriples, t.getObject(), t);
            this.pushTriple(this.relationTriples, t.getPredicate(), t);
        }

        private void pushTriple(Map m, Term key, Triple t) {
            HashSet<Triple> s = (HashSet<Triple>)m.get(key);
            if (s == null) {
                s = new HashSet<Triple>();
                m.put(key, s);
            }
            s.add(t);
        }

        private void removeTriple(Triple t) {
            this.triples.remove(t);
            this.pullTriple(this.subjectTriples, t.getSubject(), t);
            this.pullTriple(this.objectTriples, t.getObject(), t);
            this.pullTriple(this.relationTriples, t.getPredicate(), t);
        }

        private void pullTriple(Map m, Term key, Triple t) {
            Set s = (Set)m.get(key);
            if (s != null) {
                s.remove(t);
            }
        }

        @Override
        public OntologyOps getOps() {
            return this.ops;
        }

        public String toString() {
            return "ontology: " + this.getName();
        }
    }
}

