/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import junit.framework.TestCase;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyException;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.utils.ChangeVetoException;

public class OntologyTest
extends TestCase {
    private String name;
    private String description;
    private Ontology onto;
    private Term animal;
    private Term fish;
    private Term mammal;
    private Term human;
    private Term isa;
    private Triple fish_isa_animal;
    private Triple mammal_isa_animal;
    private Triple human_isa_mammal;

    protected void setUp() throws Exception {
        this.name = "Tester";
        this.description = "Our Description";
        this.onto = OntoTools.getDefaultFactory().createOntology(this.name, this.description);
        this.isa = this.onto.importTerm(OntoTools.IS_A, null);
        this.animal = this.onto.createTerm("Animal", "An animal");
        this.fish = this.onto.createTerm("Fish", "A swimming, cold-blooded thingy");
        this.mammal = this.onto.createTerm("Mammal", "A milk-producing quadraped");
        this.human = this.onto.createTerm("Human", "Us");
        this.fish_isa_animal = this.onto.createTriple(this.fish, this.animal, this.isa, null, null);
        this.mammal_isa_animal = this.onto.createTriple(this.mammal, this.animal, this.isa, null, null);
        this.human_isa_mammal = this.onto.createTriple(this.human, this.mammal, this.isa, null, null);
    }

    public void testName() {
        OntologyTest.assertEquals((String)this.onto.getName(), (String)this.name);
    }

    public void testDescription() {
        OntologyTest.assertEquals((String)this.onto.getDescription(), (String)this.description);
    }

    public void testTermsSize() {
        OntologyTest.assertEquals((int)8, (int)this.onto.getTerms().size());
    }

    public void testTermsContainAnimal() {
        OntologyTest.assertTrue((boolean)this.onto.getTerms().contains(this.animal));
    }

    public void testTermsContainFish() {
        OntologyTest.assertTrue((boolean)this.onto.getTerms().contains(this.fish));
    }

    public void testTermsContainMammal() {
        OntologyTest.assertTrue((boolean)this.onto.getTerms().contains(this.mammal));
    }

    public void testTermsContainHuman() {
        OntologyTest.assertTrue((boolean)this.onto.getTerms().contains(this.human));
    }

    public void testGetAnimalByName() {
        OntologyTest.assertEquals((Object)this.animal, (Object)this.onto.getTerm("Animal"));
    }

    public void testGetAllTriplesSize() {
        OntologyTest.assertEquals((int)3, (int)this.onto.getTriples(null, null, null).size());
    }

    public void testGetAllTriplesContainsFishIsaAnimal() {
        OntologyTest.assertTrue((boolean)this.onto.getTriples(null, null, null).contains(this.fish_isa_animal));
    }

    public void testGetAllTriplesContainsMammalIsaAnimal() {
        OntologyTest.assertTrue((boolean)this.onto.getTriples(null, null, null).contains(this.mammal_isa_animal));
    }

    public void testGetAllTriplesContainsHumanIsaMammal() {
        OntologyTest.assertTrue((boolean)this.onto.getTriples(null, null, null).contains(this.human_isa_mammal));
    }

    public void testTripleSearchingByObject() {
        OntologyTest.assertEquals((int)2, (int)this.onto.getTriples(null, this.animal, null).size());
        OntologyTest.assertEquals((int)1, (int)this.onto.getTriples(null, this.mammal, null).size());
        OntologyTest.assertEquals((int)0, (int)this.onto.getTriples(null, this.human, null).size());
    }

    public void testTripleSearchBySubject() {
        OntologyTest.assertEquals((int)1, (int)this.onto.getTriples(this.onto.getTerm("Human"), null, null).size());
    }

    public void testTripleSearchingByRelation() {
        OntologyTest.assertEquals((int)3, (int)this.onto.getTriples(null, null, this.isa).size());
    }

    public void testTripleSearchingWithAllTerms() {
        OntologyTest.assertEquals((int)1, (int)this.onto.getTriples(this.human, this.mammal, this.isa).size());
        OntologyTest.assertEquals((int)0, (int)this.onto.getTriples(this.human, this.animal, this.isa).size());
    }

    public void testTripleSearchForSameTermWithDifferentCriteria() {
        OntologyTest.assertEquals((Object)this.onto.getTriples(this.human, null, this.isa), (Object)this.onto.getTriples(null, this.mammal, this.isa));
    }

    public void testCannotCreateDuplicateTerm() throws ChangeVetoException {
        try {
            this.onto.createTerm("Human", "Us");
            OntologyTest.fail((String)"should have thrown an AlreadyExistsException");
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    public void testCannotCreateTripleTermWithForeignSubject() throws OntologyException, ChangeVetoException {
        try {
            Ontology onto2 = OntoTools.getDefaultFactory().createOntology("other", "");
            this.onto.createTriple(onto2.createTerm("foreign term", ""), this.human, this.isa, null, null);
            OntologyTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCannotCreateTripleTermWithForeignObject() throws OntologyException, ChangeVetoException {
        try {
            Ontology onto2 = OntoTools.getDefaultFactory().createOntology("other", "");
            this.onto.createTriple(this.fish, onto2.createTerm("foreign term", ""), this.isa, null, null);
            OntologyTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCannotCreateTripleTermWithForeignRelation() throws OntologyException, ChangeVetoException {
        try {
            Ontology onto2 = OntoTools.getDefaultFactory().createOntology("other", "");
            this.onto.createTriple(this.human, this.fish, onto2.createTerm("wants a", ""), null, null);
            OntologyTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

