/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.ontology.AbstractTerm;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;

public interface RemoteTerm
extends Term {
    public Term getRemoteTerm();

    public static final class Impl
    extends AbstractTerm
    implements RemoteTerm,
    Serializable {
        private final Ontology ontology;
        private final Term remoteTerm;
        private final String name;
        private Set synonyms;

        public Impl(Ontology ontology, Term remoteTerm, String name) {
            this(ontology, remoteTerm, name, null);
        }

        public Impl(Ontology ontology, Term remoteTerm, String name, Object[] synonyms) {
            if (ontology == null) {
                throw new NullPointerException("Ontology must not be null");
            }
            if (remoteTerm == null) {
                throw new NullPointerException("RemoteTerm must not be null");
            }
            if (name == null) {
                name = remoteTerm.getOntology().getName() + "." + remoteTerm.getName();
            }
            this.ontology = ontology;
            this.remoteTerm = remoteTerm;
            this.name = name;
            this.synonyms = new TreeSet();
            if (synonyms != null) {
                this.synonyms.addAll(Arrays.asList(synonyms));
            }
        }

        @Override
        public void addSynonym(Object synonym) {
            this.synonyms.add(synonym);
        }

        @Override
        public void removeSynonym(Object synonym) {
            this.synonyms.remove(synonym);
        }

        @Override
        public Object[] getSynonyms() {
            return this.synonyms.toArray();
        }

        @Override
        public String getName() {
            return this.getOntology().getName() + ":" + this.remoteTerm.getName();
        }

        @Override
        public String getDescription() {
            return this.remoteTerm.getDescription();
        }

        @Override
        public Ontology getOntology() {
            return this.ontology;
        }

        @Override
        public Term getRemoteTerm() {
            return this.remoteTerm;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Annotation getAnnotation() {
            return this.remoteTerm.getAnnotation();
        }
    }
}

