/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import junit.framework.TestCase;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;

public class TermImplTest
extends TestCase {
    private Ontology onto;

    protected void setUp() throws Exception {
        this.onto = OntoTools.getDefaultFactory().createOntology("test", "");
    }

    public void testUnequalWhenNotSameObject() {
        TermImplTest.assertFalse((boolean)new Term.Impl(this.onto, new String("test term"), new String("")).equals(new Term.Impl(this.onto, new String("test term"), new String(""))));
    }

    public void testToString() {
        TermImplTest.assertEquals((String)"name", (String)new Term.Impl(this.onto, "name", "").toString());
    }

    public void testGetAnnotationIsBlank() {
        TermImplTest.assertEquals((String)"{}", (String)new Term.Impl(this.onto, "", "").getAnnotation().toString());
    }

    public void testCannotConstructWithNullName() {
        try {
            new Term.Impl(this.onto, null, "");
            TermImplTest.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCannotConstructWithNullOntology() {
        try {
            new Term.Impl(null, "", "");
            TermImplTest.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCannotConstructWithNullDescription() {
        try {
            new Term.Impl(this.onto, "", null);
            TermImplTest.fail((String)"Should have thrown a NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

