/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import junit.framework.TestCase;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.utils.ChangeVetoException;

public class TripleImplTest
extends TestCase {
    private Ontology onto;
    private Term subject;
    private Term object;
    private Term relation;

    protected void setUp() throws Exception {
        this.onto = OntoTools.getDefaultFactory().createOntology("test", "");
        this.subject = this.onto.createTerm("subject", "");
        this.object = this.onto.createTerm("object", "");
        this.relation = this.onto.importTerm(OntoTools.IS_A, null);
    }

    public void testEqualsWhenEqual() throws ChangeVetoException, AlreadyExistsException {
        Triple.Impl triple1 = new Triple.Impl(this.subject, this.object, this.relation);
        Triple.Impl triple2 = new Triple.Impl(this.subject, this.object, this.relation);
        TripleImplTest.assertEquals((Object)triple1, (Object)triple2);
    }

    public void testEqualsWhenSubjectsUnequal() throws ChangeVetoException, AlreadyExistsException {
        Triple.Impl triple1 = new Triple.Impl(this.subject, this.object, this.relation);
        Triple.Impl triple2 = new Triple.Impl(this.onto.createTerm("something else", ""), this.object, this.relation);
        TripleImplTest.assertFalse((boolean)triple1.equals(triple2));
    }

    public void testEqualsWhenObjectsUnequal() throws ChangeVetoException, AlreadyExistsException {
        Triple.Impl triple1 = new Triple.Impl(this.subject, this.object, this.relation);
        Triple.Impl triple2 = new Triple.Impl(this.subject, this.onto.createTerm("something else", ""), this.relation);
        TripleImplTest.assertFalse((boolean)triple1.equals(triple2));
    }

    public void testEqualsWhenRelationsUnequal() throws ChangeVetoException, AlreadyExistsException {
        Triple.Impl triple1 = new Triple.Impl(this.subject, this.object, this.relation);
        Triple.Impl triple2 = new Triple.Impl(this.subject, this.object, this.onto.importTerm(OntoTools.RELATION, null));
        TripleImplTest.assertFalse((boolean)triple1.equals(triple2));
    }

    public void testHashcodesEqualWhenEqual() throws ChangeVetoException, AlreadyExistsException {
        Triple.Impl triple1 = new Triple.Impl(this.subject, this.object, this.relation);
        Triple.Impl triple2 = new Triple.Impl(this.subject, this.object, this.relation);
        TripleImplTest.assertEquals((int)triple1.hashCode(), (int)triple2.hashCode());
    }

    public void testCannotConstructWithNullSubject() throws ChangeVetoException, AlreadyExistsException {
        try {
            new Triple.Impl(null, this.object, this.relation);
            TripleImplTest.fail((String)"should have thrown an IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCannotConstructWithNullObject() {
        try {
            new Triple.Impl(this.subject, null, this.relation);
            TripleImplTest.fail((String)"should have thrown an IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCannotConstructWithNullRelation() {
        try {
            new Triple.Impl(this.subject, this.object, null);
            TripleImplTest.fail((String)"should have thrown an IllegalArgumentException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

