/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.SVMKernel;

public class RadialBaseKernel
extends NestedKernel {
    private double width;

    public RadialBaseKernel() {
        this(null, 1.0);
    }

    public RadialBaseKernel(SVMKernel nested, double width) {
        super(nested);
        this.width = width;
    }

    @Override
    public double evaluate(Object a, Object b) {
        SVMKernel k = this.getNestedKernel();
        double w = this.getWidth();
        return Math.exp(-Math.abs(2.0 * k.evaluate(a, b) - k.evaluate(a, a) - k.evaluate(b, b)) / (2.0 * w * w));
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public String toString() {
        return "Radial base kernel K(x, k) = exp(-abs(k(x,x) - k(y,y)) / (2*" + this.getWidth() + "^2)" + "; k = " + this.getNestedKernel().toString();
    }
}

