/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.RadialBaseKernel;
import org.biojava.stats.svm.SMOTrainer;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMTarget;

public class ClassifierExample {
    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        f.getContentPane().setLayout(new BorderLayout());
        final PointClassifier pc = new PointClassifier();
        f.getContentPane().add("Center", pc);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        ButtonGroup bGroup = new ButtonGroup();
        final JRadioButton rbPos = new JRadioButton("postive");
        bGroup.add(rbPos);
        JRadioButton rbNeg = new JRadioButton("negative");
        bGroup.add(rbNeg);
        ActionListener addTypeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                pc.setAddPos(rbPos.isSelected());
            }
        };
        rbPos.addActionListener(addTypeAction);
        panel.add(rbPos);
        rbNeg.addActionListener(addTypeAction);
        panel.add(rbNeg);
        ActionListener classifyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                pc.classify();
            }
        };
        JButton classifyB = new JButton("classify");
        classifyB.addActionListener(classifyAction);
        panel.add(classifyB);
        ActionListener clearAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                pc.clear();
            }
        };
        JButton clearB = new JButton("clear");
        clearB.addActionListener(clearAction);
        panel.add(clearB);
        rbPos.setSelected(pc.getAddPos());
        rbNeg.setSelected(!pc.getAddPos());
        JComboBox<String> kernelBox = new JComboBox<String>();
        kernelBox.addItem("polynomeal");
        kernelBox.addItem("rbf");
        kernelBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object o = e.getItem();
                    if (o.equals("polynomeal")) {
                        pc.setKernel(PointClassifier.polyKernel);
                    } else if (o.equals("rbf")) {
                        pc.setKernel(PointClassifier.rbfKernel);
                    }
                }
            }
        });
        panel.add(kernelBox);
        f.getContentPane().add("North", panel);
        f.setSize(400, 300);
        f.setVisible(true);
    }

    public static class PointClassifier
    extends JComponent {
        public static SVMKernel polyKernel;
        public static SVMKernel rbfKernel;
        public static SMOTrainer trainer;
        private SVMTarget target = new SimpleSVMTarget();
        private SVMClassifierModel model = null;
        private boolean addPos;
        private Shape posShape;
        private Shape negShape;
        private Paint svPaint;
        private Paint plainPaint;
        private Paint posPaint;
        private Paint negPaint;
        private SVMKernel kernel;

        public void setKernel(SVMKernel kernel) {
            this.firePropertyChange("kernel", this.kernel, kernel);
            this.kernel = kernel;
        }

        public SVMKernel getKernel() {
            return this.kernel;
        }

        public void setAddPos(boolean addPos) {
            this.firePropertyChange("addPos", this.addPos, addPos);
            this.addPos = addPos;
        }

        public boolean getAddPos() {
            return this.addPos;
        }

        public void setPosShape(Shape posShape) {
            this.firePropertyChange("posShape", this.posShape, posShape);
            this.posShape = posShape;
        }

        public Shape getPosShape() {
            return this.posShape;
        }

        public void setNegShape(Shape negShape) {
            this.firePropertyChange("negShape", this.negShape, negShape);
            this.negShape = negShape;
        }

        public Shape getNegShape() {
            return this.negShape;
        }

        public void clear() {
            this.target.clear();
            this.model = null;
            this.repaint();
        }

        public void classify() {
            new Thread(){

                @Override
                public void run() {
                    Cursor c = PointClassifier.this.getCursor();
                    PointClassifier.this.setCursor(new Cursor(3));
                    System.out.println("Training");
                    PointClassifier.this.model = trainer.trainModel(PointClassifier.this.target, PointClassifier.this.kernel, null);
                    System.out.println("Threshold = " + PointClassifier.this.model.getThreshold());
                    for (Object item : PointClassifier.this.model.items()) {
                        System.out.println(item + "\t" + PointClassifier.this.target.getTarget(item) + "\t" + PointClassifier.this.model.getAlpha(item) + "\t" + PointClassifier.this.model.classify(item));
                    }
                    PointClassifier.this.model = PointClassifier.this.model;
                    PointClassifier.this.setCursor(c);
                    PointClassifier.this.repaint();
                }
            }.start();
        }

        public PointClassifier() {
            this.setCursor(new Cursor(1));
            this.addPos = true;
            this.setPosShape(new Rectangle2D.Double(-2.0, -2.0, 5.0, 5.0));
            this.setNegShape(new Ellipse2D.Double(-2.0, -2.0, 5.0, 5.0));
            this.setKernel(polyKernel);
            this.plainPaint = Color.black;
            this.svPaint = Color.green;
            this.posPaint = Color.red;
            this.negPaint = Color.blue;
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    Point p = me.getPoint();
                    if (PointClassifier.this.getAddPos()) {
                        PointClassifier.this.target.addItemTarget(p, 1.0);
                    } else {
                        PointClassifier.this.target.addItemTarget(p, -1.0);
                    }
                    PointClassifier.this.model = null;
                    PointClassifier.this.repaint();
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform at = new AffineTransform();
            int i = 0;
            Rectangle r = g2.getClipBounds();
            int step = 3;
            if (this.model != null) {
                Rectangle rr = new Rectangle(r.x, r.y, step, step);
                Point p = new Point(r.x, r.y);
                for (int x = r.x; x < r.x + r.width; x += step) {
                    p.x = x;
                    rr.x = x;
                    for (int y = r.y; y < r.y + r.height; y += step) {
                        p.y = y;
                        rr.y = y;
                        double s = this.model.classify(p);
                        if (s <= -1.0) {
                            g2.setPaint(this.negPaint);
                        } else if (s >= 1.0) {
                            g2.setPaint(this.posPaint);
                        } else {
                            g2.setPaint(Color.white);
                        }
                        g2.fill(rr);
                    }
                }
            }
            Set supportVectors = Collections.EMPTY_SET;
            if (this.model != null) {
                supportVectors = this.model.items();
            }
            for (Point2D p : this.target.items()) {
                at.setToTranslation(p.getX(), p.getY());
                Shape glyph = this.target.getTarget(p) > 0.0 ? this.getPosShape() : this.getNegShape();
                Shape s = at.createTransformedShape(glyph);
                if (supportVectors.contains(p)) {
                    g2.setPaint(this.svPaint);
                } else {
                    g2.setPaint(this.plainPaint);
                }
                g2.draw(s);
                ++i;
            }
        }

        static {
            trainer = new SMOTrainer();
            trainer.setC(1.0E7);
            trainer.setEpsilon(1.0E-9);
            SVMKernel k = new SVMKernel(){

                @Override
                public double evaluate(Object a, Object b) {
                    Point2D pa = (Point2D)a;
                    Point2D pb = (Point2D)b;
                    double dot = pa.getX() * pb.getX() + pa.getY() * pb.getY();
                    return dot;
                }
            };
            PolynomialKernel pk = new PolynomialKernel();
            pk.setNestedKernel(k);
            pk.setOrder(2.0);
            pk.setConstant(1.0);
            pk.setMultiplier(1.0E-7);
            RadialBaseKernel rb = new RadialBaseKernel();
            rb.setNestedKernel(k);
            rb.setWidth(10000.0);
            polyKernel = pk;
            rbfKernel = rb;
        }
    }
}

