/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListTools
implements Serializable {
    public static final Mapper NULL_MAPPER = new Mapper(){

        @Override
        public Object map(Object val) {
            return val;
        }
    };

    public static Iterator nonRemoveIterator(Iterator i) {
        final Iterator it = i;
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                return it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static List createList(List l) {
        switch (l.size()) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.nCopies(1, l.get(0));
            }
            case 2: {
                Doublet d = new Doublet(l.get(0), l.get(1));
                return d;
            }
            case 3: {
                Triplet t = new Triplet(l.get(0), l.get(1), l.get(2));
                return t;
            }
        }
        return new ArrayList(l);
    }

    public static List createList(Object[] a) {
        switch (a.length) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections.nCopies(1, a[0]);
            }
            case 2: {
                Doublet d = new Doublet(a[0], a[1]);
                return d;
            }
            case 3: {
                Triplet t = new Triplet(a[0], a[1], a[2]);
                return t;
            }
        }
        return Arrays.asList(a);
    }

    public static SeriesList createSeriesList(String leader, String trailer, int size) {
        return new SeriesList(leader, trailer, size);
    }

    public static List mapList(final List list, final Mapper mapper) {
        return new AbstractList(){

            @Override
            public Object get(int index) {
                return mapper.map(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static Set mapSet(final Set set, final Mapper mapper) {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    Iterator i;
                    {
                        this.i = set.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    public Object next() {
                        return mapper.map(this.i.next());
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return set.size();
            }
        };
    }

    public static Map mapMap(final Map map, final Mapper keyMapper, final Mapper valMapper) {
        return new AbstractMap(){

            @Override
            public Set entrySet() {
                return ListTools.mapSet(map.entrySet(), new Mapper(){

                    @Override
                    public Object map(Object val) {
                        final Map.Entry ent = (Map.Entry)val;
                        return new Map.Entry(){

                            public Object getKey() {
                                return keyMapper.map(ent.getKey());
                            }

                            public Object getValue() {
                                return valMapper.map(ent.getValue());
                            }

                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                });
            }
        };
    }

    public static interface Mapper {
        public Object map(Object var1);
    }

    public static class SeriesList
    extends AbstractList {
        private final String leader;
        private final String trailer;
        private final int size;

        private SeriesList(String leader, String trailer, int size) {
            if (leader == null) {
                throw new NullPointerException("Leader was null. Use the empty string instead");
            }
            if (trailer == null) {
                throw new NullPointerException("Trailer was null. Use the empty string instead");
            }
            if (size < 0) {
                throw new IllegalArgumentException("Size must be zero or positive: " + size);
            }
            this.leader = leader;
            this.trailer = trailer;
            this.size = size;
        }

        public String getLeader() {
            return this.leader;
        }

        public String getTrailer() {
            return this.trailer;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Object get(int indx) {
            return this.leader + indx + this.trailer;
        }
    }

    public static class Triplet
    extends AbstractList
    implements Serializable {
        private Object a;
        private Object b;
        private Object c;

        public Triplet() {
        }

        public Triplet(Object a, Object b, Object c) {
            this();
            this.set(a, b, c);
        }

        public void set(Object a, Object b, Object c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public void setA(Object a) {
            this.a = a;
        }

        public void setB(Object b) {
            this.b = b;
        }

        public void setC(Object c) {
            this.c = c;
        }

        public Object getA() {
            return this.a;
        }

        public Object getB() {
            return this.b;
        }

        public Object getC() {
            return this.c;
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public Object get(int indx) {
            switch (indx) {
                case 0: {
                    return this.a;
                }
                case 1: {
                    return this.b;
                }
                case 2: {
                    return this.c;
                }
            }
            throw new IndexOutOfBoundsException("indx must be 0 or 1");
        }

        public Iterator getIterator() {
            return new Iterator(){
                private int indx = 0;

                @Override
                public boolean hasNext() {
                    return this.indx < 3;
                }

                public Object next() {
                    return Triplet.this.get(this.indx++);
                }

                @Override
                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + this.a.hashCode();
            hashcode = 31 * hashcode + this.b.hashCode();
            hashcode = 31 * hashcode + this.c.hashCode();
            return hashcode;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (other.size() != 3) {
                return false;
            }
            return other.get(0).equals(this.a) && other.get(1).equals(this.b) && other.get(2).equals(this.c);
        }
    }

    public static class Doublet
    extends AbstractList
    implements Serializable {
        private Object a;
        private Object b;

        public Doublet() {
        }

        public Doublet(Object a, Object b) {
            this();
            this.set(a, b);
        }

        public void set(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public void setA(Object a) {
            this.a = a;
        }

        public void setB(Object b) {
            this.b = b;
        }

        public Object getA() {
            return this.a;
        }

        public Object getB() {
            return this.b;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Object get(int indx) {
            switch (indx) {
                case 0: {
                    return this.a;
                }
                case 1: {
                    return this.b;
                }
            }
            throw new IndexOutOfBoundsException("indx must be 0 or 1");
        }

        public Iterator getIterator() {
            return new Iterator(){
                private int indx = 0;

                @Override
                public boolean hasNext() {
                    return this.indx < 2;
                }

                public Object next() {
                    return Doublet.this.get(this.indx++);
                }

                @Override
                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int hashCode() {
            int hashcode = 1;
            hashcode = 31 * hashcode + this.a.hashCode();
            hashcode = 31 * hashcode + this.b.hashCode();
            return hashcode;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof List)) {
                return false;
            }
            List other = (List)o;
            if (other.size() != 2) {
                return false;
            }
            return other.get(0).equals(this.a) && other.get(1).equals(this.b);
        }
    }
}

