/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import junit.framework.TestCase;
import org.biojava.utils.RepeatedCharSequence;

public class RepeatedCharSequenceTest
extends TestCase {
    public void testDefaultConstructor() {
        RepeatedCharSequence rcs = new RepeatedCharSequence();
        String rcsS = rcs.toString();
        RepeatedCharSequenceTest.assertEquals((String)"Empty String", (String)"", (String)rcsS);
    }

    public void testCustomConstructor() {
        RepeatedCharSequence rcs = new RepeatedCharSequence(5, 'x');
        String rcsS = rcs.toString();
        RepeatedCharSequenceTest.assertEquals((String)"Five x", (String)"xxxxx", (String)rcsS);
    }

    public void testLengthIncrease() {
        RepeatedCharSequence rcs = new RepeatedCharSequence(4, '?');
        String rcsS1 = rcs.toString();
        rcs.setLength(8);
        String rcsS2 = rcs.toString();
        RepeatedCharSequenceTest.assertEquals((String)"Original length 4", (int)4, (int)rcsS1.length());
        RepeatedCharSequenceTest.assertEquals((String)"Current length 8", (int)8, (int)rcsS2.length());
        RepeatedCharSequenceTest.assertEquals((String)"Eight ?", (String)"????????", (String)rcsS2);
    }

    public void testLengthDecrease() {
        RepeatedCharSequence rcs = new RepeatedCharSequence(8, '*');
        String rcsS1 = rcs.toString();
        rcs.setLength(4);
        String rcsS2 = rcs.toString();
        RepeatedCharSequenceTest.assertEquals((String)"Original length 8", (int)8, (int)rcsS1.length());
        RepeatedCharSequenceTest.assertEquals((String)"Current length 4", (int)4, (int)rcsS2.length());
        RepeatedCharSequenceTest.assertEquals((String)"Four *", (String)"****", (String)rcsS2);
    }

    public void testCharChange() {
        RepeatedCharSequence rcs = new RepeatedCharSequence(4, '$');
        String rcsS1 = rcs.toString();
        rcs.setCharacter('@');
        String rcsS2 = rcs.toString();
        System.out.println("JAM");
        RepeatedCharSequenceTest.assertEquals((String)"Length not changed", (int)rcsS1.length(), (int)rcsS2.length());
        RepeatedCharSequenceTest.assertEquals((String)"Now a string of @", (String)"@@@@", (String)rcsS2);
    }

    public void testSubSequence() {
        RepeatedCharSequence rcs = new RepeatedCharSequence(1000, 'k');
        CharSequence rcs2 = rcs.subSequence(100, 110);
        CharSequence rcs3 = rcs2.subSequence(3, 3);
        RepeatedCharSequenceTest.assertEquals((String)"10 ks", (String)"kkkkkkkkkk", (String)((Object)rcs2).toString());
        RepeatedCharSequenceTest.assertEquals((String)"empty", (String)"", (String)((Object)rcs3).toString());
    }
}

