/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SmallSet
extends AbstractSet {
    private int vid = 0;
    private Object[] items;
    private int numItems;

    public SmallSet() {
        this(2);
    }

    public SmallSet(int size) {
        this.items = new Object[size];
        this.numItems = 0;
    }

    public SmallSet(Collection col) {
        if (!(col instanceof Set)) {
            col = new HashSet(col);
        }
        this.numItems = col.size();
        this.items = new Object[this.numItems];
        this.items = col.toArray(this.items);
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.numItems; ++i) {
            if (!this.items[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.numItems;
    }

    @Override
    public boolean add(Object o) {
        if (this.contains(o)) {
            return false;
        }
        if (this.numItems == this.items.length) {
            Object[] tmp = new Object[this.items.length * this.items.length];
            System.arraycopy(this.items, 0, tmp, 0, this.items.length);
            this.items = tmp;
        }
        this.items[this.numItems++] = o;
        ++this.vid;
        return true;
    }

    private boolean remove(int i) {
        System.arraycopy(this.items, i, this.items, i - 1, this.numItems - i);
        --this.numItems;
        ++this.vid;
        return true;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            int vid;
            int i;
            {
                this.vid = SmallSet.this.vid;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                this.validate();
                return this.i < SmallSet.this.numItems;
            }

            public Object next() {
                this.validate();
                return SmallSet.this.items[this.i++];
            }

            @Override
            public void remove() {
                this.validate();
                SmallSet.this.remove(this.i--);
                this.vid = SmallSet.this.vid;
            }

            private void validate() {
                if (this.vid != SmallSet.this.vid) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }
}

