/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.lsid;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.utils.lsid.LifeScienceIdentifier;
import org.biojava.utils.lsid.LifeScienceIdentifierParseException;

public class LifeScienceIdentifierTest
extends TestCase {
    public LifeScienceIdentifierTest(String name) {
        super(name);
    }

    public void testValueOfParameters() {
        LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", "revisionId");
        LifeScienceIdentifierTest.assertNotNull((Object)lsid);
        LifeScienceIdentifierTest.assertTrue((boolean)"authorityId".equals(lsid.getAuthorityId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"namespaceId".equals(lsid.getNamespaceId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"objectId".equals(lsid.getObjectId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"revisionId".equals(lsid.getRevisionId()));
    }

    public void testValueOfParametersNullRevisionId() {
        LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", null);
        LifeScienceIdentifierTest.assertNotNull((Object)lsid);
        LifeScienceIdentifierTest.assertTrue((boolean)"authorityId".equals(lsid.getAuthorityId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"namespaceId".equals(lsid.getNamespaceId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"objectId".equals(lsid.getObjectId()));
        LifeScienceIdentifierTest.assertTrue((lsid.getRevisionId() == null ? 1 : 0) != 0);
    }

    public void testValueOfParametersEmptyRevisionId() {
        LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", "");
        LifeScienceIdentifierTest.assertNotNull((Object)lsid);
        LifeScienceIdentifierTest.assertTrue((boolean)"authorityId".equals(lsid.getAuthorityId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"namespaceId".equals(lsid.getNamespaceId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"objectId".equals(lsid.getObjectId()));
        LifeScienceIdentifierTest.assertTrue((boolean)"".equals(lsid.getRevisionId()));
    }

    public void testValueOfString() {
        try {
            LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf("urn:lsid:authorityId:namespaceId:objectId:revisionId");
            LifeScienceIdentifierTest.assertNotNull((Object)lsid);
            LifeScienceIdentifierTest.assertTrue((boolean)"authorityId".equals(lsid.getAuthorityId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"namespaceId".equals(lsid.getNamespaceId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"objectId".equals(lsid.getObjectId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"revisionId".equals(lsid.getRevisionId()));
        }
        catch (LifeScienceIdentifierParseException e) {
            LifeScienceIdentifierTest.fail((String)e.getMessage());
        }
    }

    public void testValueOfStringNullRevisionId() {
        try {
            LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf("urn:lsid:authorityId:namespaceId:objectId");
            LifeScienceIdentifierTest.assertNotNull((Object)lsid);
            LifeScienceIdentifierTest.assertTrue((boolean)"authorityId".equals(lsid.getAuthorityId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"namespaceId".equals(lsid.getNamespaceId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"objectId".equals(lsid.getObjectId()));
            LifeScienceIdentifierTest.assertTrue((lsid.getRevisionId() == null ? 1 : 0) != 0);
        }
        catch (LifeScienceIdentifierParseException e) {
            LifeScienceIdentifierTest.fail((String)e.getMessage());
        }
    }

    public void testValueOfStringEmptyRevisionId() {
        try {
            LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf("urn:lsid:authorityId:namespaceId:objectId:");
            LifeScienceIdentifierTest.assertNotNull((Object)lsid);
            LifeScienceIdentifierTest.assertTrue((boolean)"authorityId".equals(lsid.getAuthorityId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"namespaceId".equals(lsid.getNamespaceId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"objectId".equals(lsid.getObjectId()));
            LifeScienceIdentifierTest.assertTrue((boolean)"".equals(lsid.getRevisionId()));
        }
        catch (LifeScienceIdentifierParseException e) {
            LifeScienceIdentifierTest.fail((String)e.getMessage());
        }
    }

    private boolean throwsParseException(String value) {
        try {
            LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf(value);
            lsid = lsid == null ? null : lsid;
        }
        catch (LifeScienceIdentifierParseException e) {
            return true;
        }
        return false;
    }

    public void testParseErrors() {
        List<String> parseErrors = Arrays.asList("", "urn:", "urn:lsid", "urn:lsid:", "urn:lsid:authorityId", "urn:lsid:authorityId:namespaceId", "urn:lsid:authorityId:namespaceId:objectId:revisionId:extraAttribute", "authority:", "authority:namespace:", "authority:namespace:objectId:");
        for (String value : parseErrors) {
            if (this.throwsParseException(value)) continue;
            LifeScienceIdentifierTest.fail((String)("expected LifeScienceIdentifierParseException for: " + value));
        }
    }

    private boolean throwsNullPointerException(String authorityId, String namespaceId, String objectId) {
        try {
            LifeScienceIdentifier lsid = LifeScienceIdentifier.valueOf(authorityId, namespaceId, objectId);
            lsid = lsid == null ? null : lsid;
        }
        catch (NullPointerException e) {
            return true;
        }
        return false;
    }

    public void testValueOfThrowsNullPointerException() {
        if (!this.throwsNullPointerException(null, "namespaceId", "objectId")) {
            LifeScienceIdentifierTest.fail((String)"expected NullPointerException for null, namespaceId, objectId");
        }
        if (!this.throwsNullPointerException("authorityId", null, "objectId")) {
            LifeScienceIdentifierTest.fail((String)"expected NullPointerException for authorityId, null, objectId");
        }
        if (!this.throwsNullPointerException("authorityId", "namespaceId", null)) {
            LifeScienceIdentifierTest.fail((String)"expected NullPointerException for authorityId, namespaceId, null");
        }
    }

    public void testObjectContract() {
        LifeScienceIdentifier lsid0 = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", "revisionId");
        LifeScienceIdentifier lsid1 = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", "revisionId");
        LifeScienceIdentifier lsid2 = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", "revisionId_1");
        LifeScienceIdentifier lsid3 = LifeScienceIdentifier.valueOf("authorityId_1", "namespaceId", "objectId", "revisionId");
        LifeScienceIdentifier lsid4 = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", null);
        LifeScienceIdentifier lsid5 = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", "");
        LifeScienceIdentifierTest.assertTrue((lsid0 != lsid1 ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((boolean)lsid0.equals(lsid1));
        LifeScienceIdentifierTest.assertTrue((lsid0.hashCode() == lsid1.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid1 != lsid0 ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((boolean)lsid1.equals(lsid0));
        LifeScienceIdentifierTest.assertTrue((lsid1.hashCode() == lsid0.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid0.equals(lsid2) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid0.hashCode() != lsid2.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid2.equals(lsid0) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid2.hashCode() != lsid0.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid0.equals(lsid3) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid0.hashCode() != lsid3.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid3.equals(lsid0) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid3.hashCode() != lsid0.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid0.equals(lsid4) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid0.hashCode() != lsid4.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid4.equals(lsid0) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid4.hashCode() != lsid0.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid0.equals(lsid5) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid0.hashCode() != lsid5.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid5.equals(lsid0) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid5.hashCode() != lsid0.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid4.equals(lsid5) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid4.hashCode() != lsid5.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((!lsid5.equals(lsid4) ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((lsid5.hashCode() != lsid4.hashCode() ? 1 : 0) != 0);
        LifeScienceIdentifierTest.assertTrue((boolean)"urn:lsid:authorityId:namespaceId:objectId:revisionId".equals(lsid0.toString()));
        LifeScienceIdentifierTest.assertTrue((boolean)"urn:lsid:authorityId:namespaceId:objectId:revisionId".equals(lsid1.toString()));
        LifeScienceIdentifierTest.assertTrue((boolean)"urn:lsid:authorityId:namespaceId:objectId:revisionId_1".equals(lsid2.toString()));
        LifeScienceIdentifierTest.assertTrue((boolean)"urn:lsid:authorityId_1:namespaceId:objectId:revisionId".equals(lsid3.toString()));
        LifeScienceIdentifierTest.assertTrue((boolean)"urn:lsid:authorityId:namespaceId:objectId".equals(lsid4.toString()));
        LifeScienceIdentifierTest.assertTrue((boolean)"urn:lsid:authorityId:namespaceId:objectId:".equals(lsid5.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerialization() {
        LifeScienceIdentifier lsid0 = LifeScienceIdentifier.valueOf("authorityId", "namespaceId", "objectId", "revisionId");
        LifeScienceIdentifier lsid1 = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(baos));
            oos.writeObject(lsid0);
            oos.flush();
            ois = new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(baos.toByteArray())));
            lsid1 = (LifeScienceIdentifier)ois.readObject();
            LifeScienceIdentifierTest.assertTrue((lsid0 != lsid1 ? 1 : 0) != 0);
            LifeScienceIdentifierTest.assertTrue((lsid0.equals(lsid1) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            LifeScienceIdentifierTest.fail((String)e.getMessage());
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e1) {}
            try {
                ois.close();
            }
            catch (Exception e2) {}
        }
    }
}

