/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.process;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import junit.extensions.RepeatedTest;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biojava.utils.process.ExternalProcess;
import org.biojava.utils.process.ReaderInputHandler;
import org.biojava.utils.process.SimpleInputHandler;
import org.biojava.utils.process.SimpleOutputHandler;
import org.biojava.utils.process.WriterOutputHandler;

public class ExternalProcessTest
extends TestCase {
    private static final String INPUT_MORE = "test";
    private static ExternalProcess ep = null;
    private static String commandMore = null;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSuite(ExternalProcessTest.class));
        TestRunner.run((Test)new RepeatedTest((Test)suite, 5000));
    }

    public ExternalProcessTest(String name) {
        super(name);
    }

    public void testExecuteStreams() throws IOException, InterruptedException {
        ByteArrayInputStream input = new ByteArrayInputStream(INPUT_MORE.getBytes());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        ep.setCommands(commandMore);
        ep.setInputHandler(new SimpleInputHandler(input, "in"));
        ep.setOutputHandler(new SimpleOutputHandler(output, "out"));
        ep.setErrorHandler(new SimpleOutputHandler(error, "err"));
        int exitCode = ep.execute();
        ExternalProcessTest.assertTrue((exitCode == 0 ? 1 : 0) != 0);
        ExternalProcessTest.assertEquals((String)INPUT_MORE, (String)output.toString().trim());
        ExternalProcessTest.assertEquals((String)"", (String)error.toString());
    }

    public void testExecuteMore() throws IOException, InterruptedException {
        StringWriter outputString = new StringWriter();
        StringWriter errorString = new StringWriter();
        StringReader inputString = new StringReader(INPUT_MORE);
        ep.setCommands(commandMore);
        ep.setOutputHandler(new WriterOutputHandler(outputString, "out"));
        ep.setErrorHandler(new WriterOutputHandler(errorString, "err"));
        ep.setInputHandler(new ReaderInputHandler(inputString, "in"));
        int exitCode = ep.execute();
        ExternalProcessTest.assertTrue((exitCode == 0 ? 1 : 0) != 0);
        ExternalProcessTest.assertEquals((String)INPUT_MORE, (String)outputString.toString().trim());
        ExternalProcessTest.assertEquals((String)"", (String)errorString.toString());
    }

    public void testStaticExecute() throws Exception {
        StringWriter outputString = new StringWriter();
        StringWriter errorString = new StringWriter();
        int exitCode = ExternalProcess.execute(commandMore, INPUT_MORE, outputString, errorString);
        ExternalProcessTest.assertTrue((exitCode == 0 ? 1 : 0) != 0);
        ExternalProcessTest.assertEquals((String)INPUT_MORE, (String)outputString.toString().trim());
        ExternalProcessTest.assertEquals((String)"", (String)errorString.toString());
    }

    public void testResolveCommands() {
        Properties props = new Properties();
        props.put("TEST", INPUT_MORE);
        String commands = "do %TEST% it";
        commands = ExternalProcess.resolveCommands(commands, props);
        ExternalProcessTest.assertEquals((String)"do test it", (String)commands);
    }

    public void testJoinCommands() {
        Object[] commandList = new String[]{"do", INPUT_MORE, "it"};
        String commands = ExternalProcess.joinCommands(commandList);
        ExternalProcessTest.assertEquals((String)"do test it", (String)commands);
    }

    static {
        commandMore = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "cmd /C more" : "cat";
        ep = new ExternalProcess();
    }
}

