/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.regex;

import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.regex.Matcher;
import org.biojava.utils.regex.Pattern;
import org.biojava.utils.regex.PatternFactory;

public class RegexTest
extends TestCase {
    private String symbols = "atatcgatttagatggatcccgcgta";
    private String patternString = "ggatcc";
    private SymbolList sl;

    protected void setUp() throws Exception {
        this.sl = DNATools.createDNA(this.symbols);
    }

    public void testRegex() throws Exception {
        PatternFactory fact = PatternFactory.makeFactory(DNATools.getDNA());
        RegexTest.assertNotNull((String)"Could not create PatternFactory object.", (Object)fact);
        Pattern pattern = fact.compile(this.patternString);
        RegexTest.assertNotNull((String)"Could not create Pattern object.", (Object)pattern);
        Matcher matcher = pattern.matcher(this.sl);
        RegexTest.assertNotNull((String)"Could not create Matcher object.", (Object)matcher);
        if (matcher.find()) {
            if (matcher.start() != 15 && matcher.end() != 21) {
                RegexTest.fail((String)"start and end yielded wrong result.");
            }
        } else {
            RegexTest.fail((String)"failed to find target at all!");
        }
        SymbolList subList = matcher.group();
        RegexTest.assertNotNull((String)"failed to extract match group.", (Object)matcher);
        RegexTest.assertEquals((String)"failed to find match group correctly.", (String)subList.seqString(), (String)this.patternString);
    }
}

