/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.walker;

import junit.framework.TestCase;
import org.biojava.bio.BioException;
import org.biojava.utils.walker.Visitor;
import org.biojava.utils.walker.Walker;
import org.biojava.utils.walker.WalkerFactory;

public class WalkerFactoryTest
extends TestCase {
    public void testNullVisitor() {
        try {
            WalkerFactory.getInstance().getWalker(new Visitor(){});
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate null visitor"))).initCause(be));
        }
    }

    public void testAllVisitorNoReturn() {
        try {
            WalkerFactory.getInstance().getWalker(new Visitor(){});
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate all visitor with no return"))).initCause(be));
        }
    }

    public void testAllVisitorWithReturn() {
        try {
            WalkerFactory.getInstance().getWalker(new Visitor(){});
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate all visitor with return"))).initCause(be));
        }
    }

    public void testRepetition() {
        try {
            Visitor vis1 = new Visitor(){};
            Visitor vis2 = new Visitor(){};
            Walker w1 = WalkerFactory.getInstance().getWalker(vis1);
            Walker w2 = WalkerFactory.getInstance().getWalker(vis1);
            Walker w3 = WalkerFactory.getInstance().getWalker(vis2);
            WalkerFactoryTest.assertEquals((String)"Same class for same visitor: ", w1.getClass(), w2.getClass());
            WalkerFactoryTest.assertNotSame((String)"Different class for differnt visitor: ", w1.getClass(), w3.getClass());
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate null visitor"))).initCause(be));
        }
    }
}

