/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.walker;

import junit.framework.TestCase;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.walker.Visitor;
import org.biojava.utils.walker.Walker;
import org.biojava.utils.walker.WalkerFactory;

public class WalkerTest
extends TestCase {
    private FeatureFilter booring1;
    private FeatureFilter booring2;
    private FeatureFilter booring4;
    private FeatureFilter and;
    private FeatureFilter andOr;

    protected void setUp() {
        this.booring1 = new FeatureFilter.OverlapsLocation(new RangeLocation(20, 50));
        this.booring2 = new FeatureFilter.ByClass(StrandedFeature.class);
        this.booring4 = new FeatureFilter.ByClass(ComponentFeature.class);
        this.and = new FeatureFilter.And(this.booring1, this.booring2);
        this.andOr = new FeatureFilter.And(this.booring1, new FeatureFilter.Or(this.booring2, this.booring4));
    }

    public void testCountAll() {
        try {
            CountAll ca = new CountAll();
            Walker walker = WalkerFactory.getInstance().getWalker(ca);
            walker.walk(this.booring1, ca);
            WalkerTest.assertEquals((String)("One filter: " + this.booring1), (int)1, (int)ca.count);
            ca.count = 0;
            walker.walk(this.and, ca);
            WalkerTest.assertEquals((String)("Three filters: " + this.and), (int)3, (int)ca.count);
            ca.count = 0;
            walker.walk(this.andOr, ca);
            WalkerTest.assertEquals((String)("Five filters: " + this.andOr), (int)5, (int)ca.count);
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate visitor"))).initCause(be));
        }
    }

    public void testCountSome() {
        try {
            CountByClass cbc = new CountByClass();
            Walker walker = WalkerFactory.getInstance().getWalker(cbc);
            walker.walk(this.booring1, cbc);
            WalkerTest.assertEquals((String)"One filter, none interesting", (int)0, (int)cbc.count);
            cbc.count = 0;
            walker.walk(this.booring2, cbc);
            WalkerTest.assertEquals((String)"One filter, one interesting", (int)1, (int)cbc.count);
            cbc.count = 0;
            walker.walk(this.andOr, cbc);
            WalkerTest.assertEquals((String)"Five filter, two interesting", (int)2, (int)cbc.count);
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate visitor"))).initCause(be));
        }
    }

    public void testCountWithFallback() {
        try {
            CountWithFallback cwf = new CountWithFallback();
            Walker walker = WalkerFactory.getInstance().getWalker(cwf);
            walker.walk(this.booring1, cwf);
            WalkerTest.assertEquals((String)"One filter, one booring", (int)0, (int)cwf.others);
            WalkerTest.assertEquals((String)"One filter, zero interesting", (int)1, (int)cwf.byLoc);
            cwf.byLoc = 0;
            cwf.others = 0;
            walker.walk(this.booring2, cwf);
            WalkerTest.assertEquals((String)"One filter, one booring", (int)1, (int)cwf.others);
            WalkerTest.assertEquals((String)"One filter, zero interesting", (int)0, (int)cwf.byLoc);
            cwf.byLoc = 0;
            cwf.others = 0;
            walker.walk(this.andOr, cwf);
            WalkerTest.assertEquals((String)"One filter, four booring", (int)4, (int)cwf.others);
            WalkerTest.assertEquals((String)"One filter, one interesting", (int)1, (int)cwf.byLoc);
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate visitor"))).initCause(be));
        }
    }

    public void testReturnAll() {
        try {
            ReturnOne ra = new ReturnOne();
            Walker walker = WalkerFactory.getInstance().getWalker(ra);
            walker.walk(this.booring1, ra);
            WalkerTest.assertEquals((String)"One filter", (Object)new Integer(1), (Object)walker.getValue());
            walker.walk(this.andOr, ra);
            WalkerTest.assertEquals((String)"Five filters", (Object)new Integer(1), (Object)walker.getValue());
        }
        catch (BioException be) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Could not instantiate visitor"))).initCause(be));
        }
    }

    public class ReturnOne
    implements Visitor {
        public Integer featureFilter(FeatureFilter filter) {
            return new Integer(1);
        }
    }

    public class CountWithFallback
    implements Visitor {
        int byLoc = 0;
        int others = 0;

        public void featureFilter(FeatureFilter filter) {
            System.err.println("Feature: " + filter);
            ++this.others;
        }

        public void overlapsLocation(FeatureFilter.OverlapsLocation overlaps) {
            System.err.println("OverlapsLocation: " + overlaps);
            ++this.byLoc;
        }
    }

    public class CountByClass
    implements Visitor {
        int count = 0;

        public void byClass(FeatureFilter.ByClass byClass) {
            ++this.count;
        }
    }

    public class CountAll
    implements Visitor {
        int count = 0;

        public void featureFilter(FeatureFilter filter) {
            System.err.println("Increasing counter: " + filter);
            ++this.count;
        }
    }
}

