/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.Collections;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.EmptyRichAnnotation;
import org.biojavax.SimpleRichAnnotation;

public class EmptyRichAnnotationTest
extends TestCase {
    EmptyRichAnnotation ann;

    public EmptyRichAnnotationTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.ann = new EmptyRichAnnotation();
    }

    protected void tearDown() throws Exception {
        this.ann = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EmptyRichAnnotationTest.class);
        return suite;
    }

    public void testGetProperty() {
        System.out.println("testGetProperty");
        EmptyRichAnnotationTest.assertNull((Object)this.ann.getProperty(new Object()));
    }

    public void testGetNote() {
        System.out.println("testGetNote");
        EmptyRichAnnotationTest.assertNull((Object)this.ann.getNote(null));
    }

    public void testSetProperty() {
        System.out.println("testSetProperty");
        try {
            this.ann.setProperty("key", "value");
            EmptyRichAnnotationTest.fail((String)"should throw ChangeVetoException");
        }
        catch (ChangeVetoException changeVetoException) {
            // empty catch block
        }
    }

    public void testSetNoteSet() {
        System.out.println("testSetNoteSet");
        try {
            this.ann.setNoteSet(new HashSet());
            EmptyRichAnnotationTest.fail((String)"should throw ChangeVetoException");
        }
        catch (ChangeVetoException changeVetoException) {
            // empty catch block
        }
    }

    public void testAddNote() {
        System.out.println("testAddNote");
        try {
            this.ann.addNote(null);
            EmptyRichAnnotationTest.fail((String)"should throw ChangeVetoException");
        }
        catch (ChangeVetoException changeVetoException) {
            // empty catch block
        }
    }

    public void testClear() {
        System.out.println("testClear");
        try {
            this.ann.clear();
        }
        catch (ChangeVetoException ex) {
            EmptyRichAnnotationTest.fail((String)("wasn't expecting " + ex.getClass().getName()));
        }
    }

    public void testRemoveProperty() {
        System.out.println("testRemoveProperty");
        try {
            this.ann.removeProperty(new Object());
            EmptyRichAnnotationTest.fail((String)"should throw ChangeVetoException");
        }
        catch (ChangeVetoException changeVetoException) {
            // empty catch block
        }
    }

    public void testRemoveNote() {
        System.out.println("testRemoveNote");
        try {
            this.ann.removeNote(null);
            EmptyRichAnnotationTest.fail((String)"should throw ChangeVetoException");
        }
        catch (ChangeVetoException changeVetoException) {
            // empty catch block
        }
    }

    public void testContainsProperty() {
        System.out.println("testContainsProperty");
        EmptyRichAnnotationTest.assertFalse((boolean)this.ann.containsProperty(new Object()));
    }

    public void testContains() {
        System.out.println("testContains");
        EmptyRichAnnotationTest.assertFalse((boolean)this.ann.contains(null));
    }

    public void testKeys() {
        System.out.println("testKeys");
        EmptyRichAnnotationTest.assertEquals((Object)Collections.EMPTY_SET, (Object)this.ann.keys());
    }

    public void testGetNoteSet() {
        System.out.println("testGetNoteSet");
        EmptyRichAnnotationTest.assertEquals((Object)Collections.EMPTY_SET, (Object)this.ann.getNoteSet());
    }

    public void testAsMap() {
        System.out.println("testAsMap");
        EmptyRichAnnotationTest.assertNotNull((Object)this.ann.asMap());
    }

    public void testEquals() {
        System.out.println("testEquals");
        EmptyRichAnnotationTest.assertTrue((boolean)this.ann.equals(new EmptyRichAnnotation()));
        EmptyRichAnnotationTest.assertFalse((boolean)this.ann.equals(new SimpleRichAnnotation()));
    }
}

