/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Comment;

public class SimpleComment
extends AbstractChangeable
implements Comment {
    private String comment;
    private int rank;
    private Integer id;

    public SimpleComment(String comment, int rank) {
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        this.comment = comment;
        this.rank = rank;
    }

    protected SimpleComment() {
    }

    protected void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRank(int rank) throws ChangeVetoException {
        if (rank == this.rank) {
            return;
        }
        if (!this.hasListeners(Comment.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Comment.RANK, new Integer(rank), new Integer(this.rank));
            ChangeSupport changeSupport = cs = this.getChangeSupport(Comment.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Comment)) {
            return false;
        }
        if (this.comment == null) {
            return false;
        }
        Comment them = (Comment)obj;
        return this.rank == them.getRank() && this.comment.equals(them.getComment());
    }

    public int compareTo(Object o) {
        if (this.comment == null) {
            return -1;
        }
        Comment them = (Comment)o;
        if (this.rank != them.getRank()) {
            return this.rank - them.getRank();
        }
        return this.comment.compareTo(them.getComment());
    }

    public int hashCode() {
        int code = 17;
        if (this.comment == null) {
            return code;
        }
        code = 37 * code + this.comment.hashCode();
        code = 37 * code + this.rank;
        return code;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.comment;
    }

    Integer getId() {
        return this.id;
    }

    void setId(Integer id) {
        this.id = id;
    }
}

