/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Comment;
import org.biojavax.SimpleComment;

public class SimpleCommentTest
extends TestCase {
    SimpleComment comment;
    String com = "Test comment";
    int rank = 1;
    ChangeListener.ChangeEventRecorder cr;

    public SimpleCommentTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.comment = new SimpleComment(this.com, this.rank);
        this.cr = new ChangeListener.ChangeEventRecorder();
        this.comment.addChangeListener(this.cr);
    }

    protected void tearDown() throws Exception {
        this.comment.removeChangeListener(this.cr);
        this.comment = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleCommentTest.class);
        return suite;
    }

    public void testSetComment() {
        System.out.println("testSetComment");
        String newCommentText = "new comment";
        this.comment.setComment(newCommentText);
        SimpleCommentTest.assertEquals((String)newCommentText, (String)this.comment.getComment());
    }

    public void testGetComment() {
        System.out.println("testGetComment");
        SimpleCommentTest.assertEquals((String)this.com, (String)this.comment.getComment());
    }

    public void testSetRank() {
        System.out.println("testSetRank");
        try {
            this.comment.setRank(2);
            ChangeEvent ev = this.cr.getEvent();
            SimpleCommentTest.assertNotNull((Object)ev);
            SimpleCommentTest.assertEquals((Object)Comment.RANK, (Object)ev.getType());
            SimpleCommentTest.assertEquals((Object)new Integer(1), (Object)ev.getPrevious());
            SimpleCommentTest.assertEquals((Object)new Integer(2), (Object)ev.getChange());
            this.comment.setRank(1);
        }
        catch (ChangeVetoException cve) {
            SimpleCommentTest.fail((String)("Unexpected exception: " + cve));
        }
    }

    public void testGetRank() {
        System.out.println("testGetRank");
        SimpleCommentTest.assertEquals((int)this.rank, (int)this.comment.getRank());
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleComment comment2 = new SimpleComment(this.com, this.rank);
        SimpleCommentTest.assertTrue((boolean)((Object)comment2).equals(this.comment));
        SimpleCommentTest.assertTrue((boolean)this.comment.equals(comment2));
        comment2 = new SimpleComment(this.com, 50);
        SimpleCommentTest.assertFalse((boolean)((Object)comment2).equals(this.comment));
        SimpleCommentTest.assertFalse((boolean)this.comment.equals(comment2));
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleComment before = new SimpleComment(this.com, 0);
        SimpleComment after = new SimpleComment(this.com, 10);
        SimpleComment equal = new SimpleComment(this.com, this.rank);
        SimpleCommentTest.assertTrue((before.compareTo(this.comment) < 0 ? 1 : 0) != 0);
        SimpleCommentTest.assertTrue((after.compareTo(this.comment) > 0 ? 1 : 0) != 0);
        SimpleCommentTest.assertTrue((equal.compareTo(this.comment) == 0 ? 1 : 0) != 0);
        SimpleCommentTest.assertTrue((this.comment.compareTo(before) > 0 ? 1 : 0) != 0);
        SimpleCommentTest.assertTrue((this.comment.compareTo(equal) == 0 ? 1 : 0) != 0);
        SimpleCommentTest.assertTrue((this.comment.compareTo(after) < 0 ? 1 : 0) != 0);
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleComment equal = new SimpleComment(this.com, this.rank);
        SimpleCommentTest.assertEquals((int)this.comment.hashCode(), (int)((Object)equal).hashCode());
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = "(#" + this.rank + ") " + this.com;
        SimpleCommentTest.assertEquals((String)expected, (String)this.comment.toString());
    }
}

