/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.SimpleCrossRef;

public class SimpleCrossRefTest
extends TestCase {
    SimpleCrossRef xref;
    String dbname = "test db";
    String accession = "1234TEST";
    int version = 99;

    public SimpleCrossRefTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.xref = new SimpleCrossRef(this.dbname, this.accession, this.version);
    }

    protected void tearDown() throws Exception {
        this.xref = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SimpleCrossRefTest.class);
        return suite;
    }

    public void testGetAnnotation() {
        System.out.println("testGetAnnotation");
        SimpleCrossRefTest.assertNotNull((Object)this.xref.getAnnotation());
        try {
            this.xref.getAnnotation().setProperty("key", "value");
        }
        catch (Exception e) {
            SimpleCrossRefTest.fail((String)"Was expecting to be able to edit the annotation");
        }
    }

    public void testGetNoteSet() {
        System.out.println("testGetNoteSet");
        SimpleCrossRefTest.assertNotNull((Object)this.xref.getNoteSet());
    }

    public void testSetNoteSet() {
        System.out.println("testSetNoteSet");
        HashSet noteSet = new HashSet();
        try {
            this.xref.setNoteSet(noteSet);
            SimpleCrossRefTest.assertEquals(noteSet, (Object)this.xref.getNoteSet());
        }
        catch (ChangeVetoException ex) {
            SimpleCrossRefTest.fail((String)"Was expecting to be able to add a new note set, got ChangeVetoException");
        }
    }

    public void testGetAccession() {
        System.out.println("testGetAccession");
        SimpleCrossRefTest.assertEquals((String)this.accession, (String)this.xref.getAccession());
    }

    public void testGetDbname() {
        System.out.println("testGetDbname");
        SimpleCrossRefTest.assertEquals((String)this.dbname, (String)this.xref.getDbname());
    }

    public void testGetVersion() {
        System.out.println("testGetVersion");
        SimpleCrossRefTest.assertEquals((int)this.version, (int)this.xref.getVersion());
    }

    public void testCompareTo() {
        System.out.println("testCompareTo");
        SimpleCrossRef before = new SimpleCrossRef("a", this.accession, this.version);
        SimpleCrossRefTest.assertTrue((before.compareTo(this.xref) < 0 ? 1 : 0) != 0);
        SimpleCrossRefTest.assertTrue((this.xref.compareTo(before) > 0 ? 1 : 0) != 0);
        before = new SimpleCrossRef(this.dbname, "1111TEST", this.version);
        SimpleCrossRefTest.assertTrue((before.compareTo(this.xref) < 0 ? 1 : 0) != 0);
        SimpleCrossRefTest.assertTrue((this.xref.compareTo(before) > 0 ? 1 : 0) != 0);
        before = new SimpleCrossRef(this.dbname, this.accession, 0);
        SimpleCrossRefTest.assertTrue((before.compareTo(this.xref) < 0 ? 1 : 0) != 0);
        SimpleCrossRefTest.assertTrue((this.xref.compareTo(before) > 0 ? 1 : 0) != 0);
        SimpleCrossRef equal = new SimpleCrossRef(this.dbname, this.accession, this.version);
        SimpleCrossRefTest.assertTrue((this.xref.compareTo(equal) == 0 ? 1 : 0) != 0);
        SimpleCrossRefTest.assertTrue((equal.compareTo(this.xref) == 0 ? 1 : 0) != 0);
        SimpleCrossRef after = new SimpleCrossRef("z", this.accession, this.version);
        SimpleCrossRefTest.assertTrue((after.compareTo(this.xref) > 0 ? 1 : 0) != 0);
        SimpleCrossRefTest.assertTrue((this.xref.compareTo(after) < 0 ? 1 : 0) != 0);
        after = new SimpleCrossRef(this.dbname, "z", this.version);
        SimpleCrossRefTest.assertTrue((after.compareTo(this.xref) > 0 ? 1 : 0) != 0);
        SimpleCrossRefTest.assertTrue((this.xref.compareTo(after) < 0 ? 1 : 0) != 0);
        after = new SimpleCrossRef(this.dbname, this.accession, 9999);
        SimpleCrossRefTest.assertTrue((after.compareTo(this.xref) > 0 ? 1 : 0) != 0);
        SimpleCrossRefTest.assertTrue((this.xref.compareTo(after) < 0 ? 1 : 0) != 0);
    }

    public void testEquals() {
        System.out.println("testEquals");
        SimpleCrossRef xref2 = new SimpleCrossRef(this.dbname, this.accession, this.version);
        SimpleCrossRefTest.assertTrue((boolean)this.xref.equals(xref2));
        SimpleCrossRefTest.assertTrue((boolean)xref2.equals(this.xref));
        xref2 = new SimpleCrossRef("other", this.accession, this.version);
        SimpleCrossRefTest.assertFalse((boolean)this.xref.equals(xref2));
        SimpleCrossRefTest.assertFalse((boolean)xref2.equals(this.xref));
        xref2 = new SimpleCrossRef(this.dbname, "jjj", this.version);
        SimpleCrossRefTest.assertFalse((boolean)this.xref.equals(xref2));
        SimpleCrossRefTest.assertFalse((boolean)xref2.equals(this.xref));
        xref2 = new SimpleCrossRef(this.dbname, this.accession, 0);
        SimpleCrossRefTest.assertFalse((boolean)this.xref.equals(xref2));
        SimpleCrossRefTest.assertFalse((boolean)xref2.equals(this.xref));
    }

    public void testHashCode() {
        System.out.println("testHashCode");
        SimpleCrossRef xref2 = new SimpleCrossRef(this.dbname, this.accession, this.version);
        SimpleCrossRefTest.assertEquals((int)this.xref.hashCode(), (int)xref2.hashCode());
    }

    public void testToString() {
        System.out.println("testToString");
        String expected = this.dbname + ":" + this.accession + "." + this.version;
        SimpleCrossRefTest.assertEquals((String)expected, (String)this.xref.toString());
    }
}

