/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.ArrayList;
import java.util.List;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.CrossRef;
import org.biojavax.DocRef;
import org.biojavax.DocRefAuthor;
import org.biojavax.utils.CRC64Checksum;

public class SimpleDocRef
extends AbstractChangeable
implements DocRef {
    private CrossRef crossref;
    private List authors;
    private String title;
    private String location;
    private String remark;
    private Integer id;

    public SimpleDocRef(List authors, String location) {
        this(authors, location, null);
    }

    public SimpleDocRef(String authors, String location) {
        this(DocRefAuthor.Tools.parseAuthorString(authors), location, null);
    }

    public SimpleDocRef(String authors, String location, String title) {
        this(DocRefAuthor.Tools.parseAuthorString(authors), location, title);
    }

    public SimpleDocRef(List authors, String location, String title) {
        if (authors == null || authors.isEmpty()) {
            throw new IllegalArgumentException("Authors cannot be null or empty");
        }
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        this.crossref = null;
        this.authors = new ArrayList();
        this.authors.addAll(authors);
        this.title = title;
        this.location = location;
        this.remark = null;
    }

    protected SimpleDocRef() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRemark(String remark) throws ChangeVetoException {
        if (this.remark != null && this.remark.equals(remark)) {
            return;
        }
        if (this.remark == null && remark == null) {
            return;
        }
        if (!this.hasListeners(DocRef.REMARK)) {
            this.remark = remark;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, DocRef.REMARK, remark, this.remark);
            ChangeSupport changeSupport = cs = this.getChangeSupport(DocRef.REMARK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.remark = remark;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    void setCRC(String CRC) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCrossref(CrossRef crossref) throws ChangeVetoException {
        if (this.crossref != null && this.crossref.equals(crossref)) {
            return;
        }
        if (this.crossref == null && crossref == null) {
            return;
        }
        if (!this.hasListeners(DocRef.CROSSREF)) {
            this.crossref = crossref;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, DocRef.CROSSREF, crossref, this.crossref);
            ChangeSupport changeSupport = cs = this.getChangeSupport(DocRef.CROSSREF);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.crossref = crossref;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    void setAuthors(String authors) {
        this.authors = DocRefAuthor.Tools.parseAuthorString(authors);
    }

    void setLocation(String location) {
        this.location = location;
    }

    void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getAuthors() {
        return DocRefAuthor.Tools.generateAuthorString(this.authors, true);
    }

    @Override
    public List getAuthorList() {
        return new ArrayList(this.authors);
    }

    @Override
    public String getCRC() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAuthors());
        sb.append(this.title == null || this.title.equals("") ? "<undef>" : this.title);
        sb.append(this.location == null || this.location.equals("") ? "<undef>" : this.location);
        CRC64Checksum cs = new CRC64Checksum();
        cs.update(sb.toString().getBytes(), 0, sb.length());
        return ((Object)cs).toString();
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    @Override
    public CrossRef getCrossref() {
        return this.crossref;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (this.authors == null) {
            return -1;
        }
        DocRef them = (DocRef)o;
        if (!this.getAuthors().equals(them.getAuthors())) {
            return this.getAuthors().compareTo(them.getAuthors());
        }
        if (!this.getLocation().equals(them.getLocation())) {
            return this.getLocation().compareTo(them.getLocation());
        }
        if (this.getTitle() == null) {
            if (them.getTitle() == null) {
                return 0;
            }
            return -1;
        }
        if (this.getTitle() != null && them.getTitle() == null) {
            return 1;
        }
        return this.getTitle().compareTo(them.getTitle());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DocRef)) {
            return false;
        }
        if (this.authors == null) {
            return false;
        }
        DocRef them = (DocRef)obj;
        return this.getAuthors().equals(them.getAuthors()) && this.getLocation().equals(them.getLocation()) && (this.getTitle() == them.getTitle() || this.getTitle() != null && this.getTitle().equals(them.getTitle()));
    }

    public int hashCode() {
        int code = 17;
        if (this.authors == null) {
            return code;
        }
        code = 37 * code + this.getAuthors().hashCode();
        code = 37 * code + this.location.hashCode();
        if (this.title != null) {
            code = 37 * code + this.title.hashCode();
        }
        return code;
    }

    public String toString() {
        return this.getAuthors() + "; " + this.getLocation();
    }

    Integer getId() {
        return this.id;
    }

    void setId(Integer id) {
        this.id = id;
    }
}

